/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl;

import java.io.IOException;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;

class LuceneReplaceMissingSortedDocValues
extends SortedDocValues {
    final SortedDocValues originalValues;
    final BytesRef missingValue;
    final int missingValuePosition;
    final boolean missingValueExist;
    boolean hasValue = false;

    LuceneReplaceMissingSortedDocValues(SortedDocValues originalValues, BytesRef missingValue) throws IOException {
        this.originalValues = originalValues;
        this.missingValue = missingValue;
        int sub = originalValues.lookupTerm(missingValue);
        if (sub < 0) {
            this.missingValuePosition = -sub - 1;
            this.missingValueExist = false;
        } else {
            this.missingValuePosition = sub;
            this.missingValueExist = true;
        }
    }

    public int ordValue() throws IOException {
        if (!this.hasValue) {
            return this.missingValuePosition;
        }
        int ordValue = this.originalValues.ordValue();
        if (!this.missingValueExist && ordValue >= this.missingValuePosition) {
            ++ordValue;
        }
        return ordValue;
    }

    public boolean advanceExact(int target) throws IOException {
        this.hasValue = this.originalValues.advanceExact(target);
        return true;
    }

    public int docID() {
        return this.originalValues.docID();
    }

    public int getValueCount() {
        if (this.missingValueExist) {
            return this.originalValues.getValueCount();
        }
        return this.originalValues.getValueCount() + 1;
    }

    public BytesRef lookupOrd(int ord) throws IOException {
        if (ord == this.missingValuePosition) {
            return this.missingValue;
        }
        if (!this.missingValueExist && ord > this.missingValuePosition) {
            return this.originalValues.lookupOrd(ord - 1);
        }
        return this.originalValues.lookupOrd(ord);
    }

    public int nextDoc() {
        throw new UnsupportedOperationException();
    }

    public int advance(int target) {
        throw new UnsupportedOperationException();
    }

    public long cost() {
        throw new UnsupportedOperationException();
    }
}

