/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexingPlanWriteWorkSet;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneSingleDocumentWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;

public class LuceneIndexIndexingPlan
implements IndexIndexingPlan<LuceneRootDocumentBuilder> {
    private final LuceneWorkFactory factory;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;
    private final Map<LuceneWriteWorkOrchestrator, List<LuceneSingleDocumentWriteWork<?>>> worksByOrchestrator = new HashMap();

    public LuceneIndexIndexingPlan(LuceneWorkFactory factory, WorkExecutionIndexManagerContext indexManagerContext, LuceneIndexEntryFactory indexEntryFactory, BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.factory = factory;
        this.indexEntryFactory = indexEntryFactory;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.getTenantIdentifier();
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, documentContributor);
        this.collect(id, routingKey, this.factory.add(this.tenantId, id, indexEntry));
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, documentContributor);
        this.collect(id, routingKey, this.factory.update(this.tenantId, id, indexEntry));
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        this.collect(id, routingKey, this.factory.delete(this.tenantId, id));
    }

    public void process() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<IndexIndexingPlanExecutionReport> executeAndReport() {
        try {
            ArrayList<CompletableFuture<IndexIndexingPlanExecutionReport>> shardReportFutures = new ArrayList<CompletableFuture<IndexIndexingPlanExecutionReport>>();
            for (Map.Entry<LuceneWriteWorkOrchestrator, List<LuceneSingleDocumentWriteWork<?>>> entry : this.worksByOrchestrator.entrySet()) {
                LuceneWriteWorkOrchestrator orchestrator = entry.getKey();
                List<LuceneSingleDocumentWriteWork<?>> works = entry.getValue();
                CompletableFuture<IndexIndexingPlanExecutionReport> shardReportFuture = new CompletableFuture<IndexIndexingPlanExecutionReport>();
                orchestrator.submit(new LuceneIndexingPlanWriteWorkSet(this.indexManagerContext.getIndexName(), works, shardReportFuture, this.commitStrategy, this.refreshStrategy));
                shardReportFutures.add(shardReportFuture);
            }
            CompletableFuture completableFuture = IndexIndexingPlanExecutionReport.allOf(shardReportFutures);
            return completableFuture;
        }
        finally {
            this.worksByOrchestrator.clear();
        }
    }

    public void discard() {
        this.worksByOrchestrator.clear();
    }

    private void collect(String documentId, String routingKey, LuceneSingleDocumentWriteWork<?> work) {
        LuceneWriteWorkOrchestrator orchestrator = this.indexManagerContext.getWriteOrchestrator(documentId, routingKey);
        List<LuceneSingleDocumentWriteWork<?>> works = this.worksByOrchestrator.get(orchestrator);
        if (works == null) {
            works = new ArrayList();
            this.worksByOrchestrator.put(orchestrator, works);
        }
        works.add(work);
    }
}

