/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class LuceneIndexWorkspace
implements IndexWorkspace {
    private final LuceneWorkFactory factory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final DetachedBackendSessionContext sessionContext;

    public LuceneIndexWorkspace(LuceneWorkFactory factory, WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.factory = factory;
        this.indexManagerContext = indexManagerContext;
        this.sessionContext = sessionContext;
    }

    public CompletableFuture<?> optimize() {
        return this.doSubmit(this.factory.optimize());
    }

    public CompletableFuture<?> purge() {
        return this.doSubmit(this.factory.deleteAll(this.sessionContext.getTenantIdentifier()));
    }

    public CompletableFuture<?> flush() {
        return this.doSubmit(this.factory.flush());
    }

    private CompletableFuture<?> doSubmit(LuceneWriteWork<?> work) {
        Collection<LuceneWriteWorkOrchestrator> orchestrators = this.indexManagerContext.getAllWriteOrchestrators();
        CompletableFuture[] futures = new CompletableFuture[orchestrators.size()];
        int i = 0;
        for (LuceneWriteWorkOrchestrator orchestrator : orchestrators) {
            futures[i] = orchestrator.submit(work, DocumentCommitStrategy.FORCE, DocumentRefreshStrategy.NONE);
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }
}

