/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneExplainWork
implements LuceneReadWork<Explanation> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearcher<?> searcher;
    private final String indexName;
    private final String documentId;
    private final Query explainedDocumentQuery;

    LuceneExplainWork(LuceneSearcher<?> searcher, String explainedDocumentIndexName, String explainedDocumentId, Query explainedDocumentQuery) {
        this.searcher = searcher;
        this.indexName = explainedDocumentIndexName;
        this.documentId = explainedDocumentId;
        this.explainedDocumentQuery = explainedDocumentQuery;
    }

    @Override
    public Explanation execute(LuceneReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher(context.getIndexReader());
            int luceneDocId = this.getLuceneDocId(indexSearcher);
            return this.searcher.explain(indexSearcher, luceneDocId);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), context.getEventContext(), e);
        }
    }

    private int getLuceneDocId(IndexSearcher indexSearcher) throws IOException {
        TopDocs topDocs = indexSearcher.search(this.explainedDocumentQuery, 1);
        if (topDocs.scoreDocs.length != 1) {
            throw log.explainUnkownDocument(this.indexName, this.documentId);
        }
        return topDocs.scoreDocs[0].doc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append(", explainedDocumentQuery=").append(this.explainedDocumentQuery).append("]");
        return sb.toString();
    }
}

