/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.LuceneAddEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneCountWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneExplainWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneFlushWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneOptimizeWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearchWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneSingleDocumentWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;

public class LuceneWorkFactoryImpl
implements LuceneWorkFactory {
    private final MultiTenancyStrategy multiTenancyStrategy;

    public LuceneWorkFactoryImpl(MultiTenancyStrategy multiTenancyStrategy) {
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    @Override
    public LuceneSingleDocumentWriteWork<?> add(String tenantId, String id, LuceneIndexEntry indexEntry) {
        return new LuceneAddEntryWork(tenantId, id, indexEntry);
    }

    @Override
    public LuceneSingleDocumentWriteWork<?> update(String tenantId, String id, LuceneIndexEntry indexEntry) {
        return this.multiTenancyStrategy.createUpdateEntryLuceneWork(tenantId, id, indexEntry);
    }

    @Override
    public LuceneSingleDocumentWriteWork<?> delete(String tenantId, String id) {
        return this.multiTenancyStrategy.createDeleteEntryLuceneWork(tenantId, id);
    }

    @Override
    public LuceneWriteWork<?> deleteAll(String tenantId) {
        return this.multiTenancyStrategy.createDeleteAllEntriesLuceneWork(tenantId);
    }

    @Override
    public LuceneWriteWork<?> flush() {
        return new LuceneFlushWork();
    }

    @Override
    public LuceneWriteWork<?> optimize() {
        return new LuceneOptimizeWork();
    }

    @Override
    public <R> LuceneReadWork<R> search(LuceneSearcher<R> searcher, Integer offset, Integer limit) {
        return new LuceneSearchWork<R>(searcher, offset, limit);
    }

    @Override
    public LuceneReadWork<Integer> count(LuceneSearcher<?> searcher) {
        return new LuceneCountWork(searcher);
    }

    @Override
    public LuceneReadWork<Explanation> explain(LuceneSearcher<?> searcher, String explainedDocumentIndexName, String explainedDocumentId, Query explainedDocumentQuery) {
        return new LuceneExplainWork(searcher, explainedDocumentIndexName, explainedDocumentId, explainedDocumentQuery);
    }
}

