/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategyInitializationContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HashShardingStrategy
implements ShardingStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "hash";
    private static final OptionalConfigurationProperty<Integer> NUMBER_OF_SHARDS = ConfigurationProperty.forKey((String)"number_of_shards").asInteger().build();
    private String[] shardIds;

    @Override
    public void initialize(ShardingStrategyInitializationContext context) {
        int numberOfShards = (Integer)NUMBER_OF_SHARDS.getOrThrow(context.getConfigurationPropertySource(), key -> log.missingPropertyValueForShardingStrategy(NAME, (String)key));
        this.shardIds = new String[numberOfShards];
        LinkedHashSet<String> shardIdSet = new LinkedHashSet<String>();
        for (int i = 0; i < numberOfShards; ++i) {
            String shardId;
            this.shardIds[i] = shardId = String.valueOf(i);
            shardIdSet.add(shardId);
        }
        context.setShardIdentifiers(shardIdSet);
    }

    @Override
    public String toShardIdentifier(String documentId, String routingKey) {
        return this.toShardIdentifier(routingKey == null ? documentId : routingKey);
    }

    @Override
    public Set<String> toShardIdentifiers(Set<String> routingKeys) {
        LinkedHashSet<String> shardIds = new LinkedHashSet<String>();
        for (String routingKey : routingKeys) {
            shardIds.add(this.toShardIdentifier(routingKey));
        }
        return shardIds;
    }

    private String toShardIdentifier(String routingKey) {
        return this.shardIds[Math.abs(HashShardingStrategy.hash(routingKey) % this.shardIds.length)];
    }

    private static int hash(String routingKey) {
        if (routingKey == null) {
            return 0;
        }
        int hash = 0;
        int length = routingKey.length();
        for (int index = 0; index < length; ++index) {
            hash = 31 * hash + routingKey.charAt(index);
        }
        return hash;
    }
}

