/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.DirectoryReader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public final class Shard {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final IndexAccessorImpl indexAccessor;
    private final LuceneWriteWorkOrchestratorImplementor writeOrchestrator;

    Shard(EventContext eventContext, IndexAccessorImpl indexAccessor, LuceneWriteWorkOrchestratorImplementor writeOrchestrator) {
        this.eventContext = eventContext;
        this.indexAccessor = indexAccessor;
        this.writeOrchestrator = writeOrchestrator;
    }

    CompletableFuture<?> start() {
        try {
            this.indexAccessor.start();
            this.writeOrchestrator.start();
            return this.writeOrchestrator.ensureIndexExists();
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)this.indexAccessor).push(LuceneWriteWorkOrchestratorImplementor::stop, (Object)this.writeOrchestrator);
            throw log.unableToInitializeIndexDirectory(e.getMessage(), this.eventContext, e);
        }
    }

    CompletableFuture<?> preStop() {
        return this.writeOrchestrator.preStop();
    }

    void stop() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(LuceneWriteWorkOrchestratorImplementor::stop, (Object)this.writeOrchestrator);
            closer.push(IndexAccessorImpl::close, (Object)this.indexAccessor);
        }
    }

    DirectoryReader openReader() throws IOException {
        return this.indexAccessor.getIndexReader();
    }

    LuceneWriteWorkOrchestrator getWriteOrchestrator() {
        return this.writeOrchestrator;
    }

    public IndexAccessorImpl getIndexAccessorForTests() {
        return this.indexAccessor;
    }
}

