/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategyInitializationContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ShardingStrategyInitializationContextImpl
implements ShardingStrategyInitializationContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<BeanReference<? extends ShardingStrategy>> SHARDING_STRATEGY = ConfigurationProperty.forKey((String)"strategy").asBeanReference(ShardingStrategy.class).withDefault((Object)BeanReference.of(ShardingStrategy.class, (String)"none")).build();
    private final IndexManagerBackendContext backendContext;
    private final IOStrategy ioStrategy;
    private final LuceneIndexModel model;
    private final IndexManagerStartContext startContext;
    private final ConfigurationPropertySource propertySource;
    private Set<String> shardIdentifiers = new LinkedHashSet<String>();

    ShardingStrategyInitializationContextImpl(IndexManagerBackendContext backendContext, IOStrategy ioStrategy, LuceneIndexModel model, IndexManagerStartContext startContext, ConfigurationPropertySource propertySource) {
        this.backendContext = backendContext;
        this.ioStrategy = ioStrategy;
        this.model = model;
        this.startContext = startContext;
        this.propertySource = propertySource;
    }

    @Override
    public void setShardIdentifiers(Set<String> shardIdentifiers) {
        this.shardIdentifiers.clear();
        this.shardIdentifiers.addAll(shardIdentifiers);
    }

    @Override
    public void setShardingDisabled() {
        this.shardIdentifiers = null;
    }

    @Override
    public String getIndexName() {
        return this.model.getIndexName();
    }

    @Override
    public BeanResolver getBeanResolver() {
        return this.startContext.getBeanResolver();
    }

    @Override
    public ConfigurationPropertySource getConfigurationPropertySource() {
        return this.propertySource;
    }

    public BeanHolder<? extends ShardingStrategy> create(Map<String, Shard> shardCollector) {
        BeanHolder shardingStrategyHolder = (BeanHolder)SHARDING_STRATEGY.getAndTransform(this.propertySource, arg_0 -> ((BeanResolver)this.getBeanResolver()).resolve(arg_0));
        ((ShardingStrategy)shardingStrategyHolder.get()).initialize(this);
        if (this.shardIdentifiers == null) {
            this.contributeShardWithSilentFailure(shardCollector, Optional.empty());
            return null;
        }
        if (this.shardIdentifiers.isEmpty()) {
            throw log.missingShardIdentifiersAfterShardingStrategyInitialization(shardingStrategyHolder.get());
        }
        for (String shardIdentifier : this.shardIdentifiers) {
            this.contributeShardWithSilentFailure(shardCollector, Optional.of(shardIdentifier));
        }
        return shardingStrategyHolder;
    }

    private void contributeShardWithSilentFailure(Map<String, Shard> shardCollector, Optional<String> shardId) {
        try {
            Shard shard = this.backendContext.createShard(this.ioStrategy, this.model, shardId);
            shardCollector.put(shardId.orElse(null), shard);
        }
        catch (RuntimeException e) {
            ContextualFailureCollector failureCollector = this.startContext.getFailureCollector();
            if (shardId.isPresent()) {
                failureCollector = failureCollector.withContext(EventContexts.fromShardId((String)shardId.get()));
            }
            failureCollector.add((Throwable)e);
        }
    }
}

