/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SleepingLockWrapper;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegatorImpl;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexAccessorImpl
implements AutoCloseable,
IndexAccessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final DirectoryHolder directoryHolder;
    private final IndexWriterProvider indexWriterProvider;
    private final IndexReaderProvider indexReaderProvider;

    public IndexAccessorImpl(EventContext eventContext, DirectoryHolder directoryHolder, IndexWriterProvider indexWriterProvider, IndexReaderProvider indexReaderProvider) {
        this.eventContext = eventContext;
        this.directoryHolder = directoryHolder;
        this.indexWriterProvider = indexWriterProvider;
        this.indexReaderProvider = indexReaderProvider;
    }

    public void start() throws IOException {
        this.directoryHolder.start();
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(IndexReaderProvider::clear, (Object)this.indexReaderProvider);
            closer.push(IndexWriterProvider::clear, (Object)this.indexWriterProvider);
            closer.push(DirectoryHolder::close, (Object)this.directoryHolder);
        }
    }

    @Override
    public void reset() throws IOException {
        log.indexAccessorReset(this.eventContext);
        this.indexWriterProvider.clear();
        this.indexReaderProvider.clear();
    }

    @Override
    public void ensureIndexExists() {
        try {
            Directory directory = this.directoryHolder.get();
            if (DirectoryReader.indexExists((Directory)directory)) {
                return;
            }
            this.initializeDirectory(directory);
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToInitializeIndexDirectory(e.getMessage(), this.eventContext, e);
        }
    }

    @Override
    public void commit() {
        try {
            IndexWriterDelegatorImpl delegator = this.indexWriterProvider.getOrNull();
            if (delegator != null) {
                delegator.commit();
            }
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCommitIndex(this.eventContext, e);
        }
    }

    @Override
    public long commitOrDelay() {
        try {
            IndexWriterDelegatorImpl delegator = this.indexWriterProvider.getOrNull();
            if (delegator != null) {
                return delegator.commitOrDelay();
            }
            return 0L;
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCommitIndex(this.eventContext, e);
        }
    }

    @Override
    public void refresh() {
        try {
            this.indexReaderProvider.refresh();
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToRefreshIndex(this.eventContext, e);
        }
    }

    @Override
    public IndexWriterDelegator getIndexWriterDelegator() throws IOException {
        return this.indexWriterProvider.getOrCreate();
    }

    @Override
    public DirectoryReader getIndexReader() throws IOException {
        return this.indexReaderProvider.getOrCreate();
    }

    public Directory getDirectoryForTests() {
        return this.directoryHolder.get();
    }

    private void initializeDirectory(Directory directory) throws IOException {
        try {
            IndexWriterConfig iwriterConfig = new IndexWriterConfig(AnalyzerConstants.KEYWORD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            SleepingLockWrapper delayedDirectory = new SleepingLockWrapper(directory, 2000L, 20L);
            IndexWriter iw = new IndexWriter((Directory)delayedDirectory, iwriterConfig);
            iw.close();
        }
        catch (LockObtainFailedException lofe) {
            log.lockingFailureDuringInitialization(directory.toString(), this.eventContext);
        }
    }
}

