/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;

public class NearRealTimeIndexReaderProvider
implements IndexReaderProvider {
    private final IndexWriterProvider indexWriterProvider;
    private final TimingSource timingSource;
    private final int refreshInterval;
    private volatile IndexReaderEntry currentReaderEntry = null;

    public NearRealTimeIndexReaderProvider(IndexWriterProvider indexWriterProvider, TimingSource timingSource, int refreshInterval) {
        this.indexWriterProvider = indexWriterProvider;
        this.timingSource = timingSource;
        this.refreshInterval = refreshInterval;
    }

    @Override
    public synchronized void clear() throws IOException {
        this.setCurrentReaderEntry(null);
    }

    @Override
    public void refresh() throws IOException {
        IndexReaderEntry entry = this.currentReaderEntry;
        if (entry != null) {
            entry.forceRefresh();
        }
    }

    @Override
    public DirectoryReader getOrCreate() throws IOException {
        IndexReaderEntry entry = this.currentReaderEntry;
        if (entry != null && entry.reader.tryIncRef()) {
            if (entry.isFresh()) {
                return entry.reader;
            }
            entry.reader.decRef();
        }
        return this.getFreshIndexReader().reader;
    }

    private synchronized IndexReaderEntry getFreshIndexReader() throws IOException {
        IndexReaderEntry freshEntry;
        IndexReaderEntry oldEntry = this.currentReaderEntry;
        if (oldEntry == null) {
            DirectoryReader newReader = this.indexWriterProvider.getOrCreate().openReader();
            freshEntry = new IndexReaderEntry(newReader, this.timingSource, this.refreshInterval);
        } else {
            DirectoryReader newReaderOrNull = this.indexWriterProvider.getOrCreate().openReaderIfChanged(oldEntry.reader);
            freshEntry = newReaderOrNull == null ? oldEntry : new IndexReaderEntry(newReaderOrNull, this.timingSource, this.refreshInterval);
        }
        if (oldEntry != freshEntry) {
            this.setCurrentReaderEntry(freshEntry);
        }
        freshEntry.reader.incRef();
        return freshEntry;
    }

    private synchronized void setCurrentReaderEntry(IndexReaderEntry newEntry) throws IOException {
        IndexReaderEntry oldEntry = this.currentReaderEntry;
        this.currentReaderEntry = newEntry;
        if (oldEntry != null) {
            oldEntry.reader.decRef();
        }
    }

    private static class IndexReaderEntry {
        private final DirectoryReader reader;
        private final TimingSource timingSource;
        private final long expiration;
        private volatile boolean refreshForced = false;

        private IndexReaderEntry(DirectoryReader reader, TimingSource timingSource, int refreshInterval) {
            this.reader = reader;
            this.timingSource = timingSource;
            this.expiration = refreshInterval == 0 ? 0L : timingSource.getMonotonicTimeEstimate() + (long)refreshInterval;
        }

        public void forceRefresh() {
            this.refreshForced = true;
        }

        boolean isFresh() throws IOException {
            if (this.refreshForced) {
                return false;
            }
            if (this.expiration == 0L || this.expiration < this.timingSource.getMonotonicTimeEstimate()) {
                return this.reader.isCurrent();
            }
            return true;
        }
    }
}

