/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.HibernateSearchConcurrentMergeScheduler;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegatorImpl;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexWriterProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final EventContext eventContext;
    private final DirectoryHolder directoryHolder;
    private final Analyzer analyzer;
    private final TimingSource timingSource;
    private final int commitInterval;
    private final ThreadProvider threadProvider;
    private final FailureHandler failureHandler;
    private final AtomicReference<IndexWriterDelegatorImpl> currentWriter = new AtomicReference();
    private final ReentrantLock currentWriterModificationLock = new ReentrantLock();

    public IndexWriterProvider(String indexName, EventContext eventContext, DirectoryHolder directoryHolder, Analyzer analyzer, TimingSource timingSource, int commitInterval, ThreadProvider threadProvider, FailureHandler failureHandler) {
        this.indexName = indexName;
        this.eventContext = eventContext;
        this.directoryHolder = directoryHolder;
        this.analyzer = analyzer;
        this.timingSource = timingSource;
        this.commitInterval = commitInterval;
        this.threadProvider = threadProvider;
        this.failureHandler = failureHandler;
    }

    public void clear() throws IOException {
        this.currentWriterModificationLock.lock();
        try {
            IndexWriterDelegatorImpl indexWriterDelegator = this.currentWriter.getAndSet(null);
            if (indexWriterDelegator != null) {
                indexWriterDelegator.close();
                log.trace("IndexWriter closed");
            }
        }
        finally {
            this.currentWriterModificationLock.unlock();
        }
    }

    public IndexWriterDelegatorImpl getOrNull() {
        return this.currentWriter.get();
    }

    public IndexWriterDelegatorImpl getOrCreate() throws IOException {
        IndexWriterDelegatorImpl indexWriterDelegator = this.currentWriter.get();
        if (indexWriterDelegator == null) {
            this.currentWriterModificationLock.lock();
            try {
                indexWriterDelegator = this.currentWriter.get();
                if (indexWriterDelegator == null) {
                    IndexWriter indexWriter = this.createNewIndexWriter();
                    indexWriterDelegator = new IndexWriterDelegatorImpl(indexWriter, this.timingSource, this.commitInterval);
                    log.trace("IndexWriter opened");
                    this.currentWriter.set(indexWriterDelegator);
                }
            }
            finally {
                this.currentWriterModificationLock.unlock();
            }
        }
        return indexWriterDelegator;
    }

    private IndexWriter createNewIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig = this.createWriterConfig();
        return new IndexWriter(this.directoryHolder.get(), indexWriterConfig);
    }

    private IndexWriterConfig createWriterConfig() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.analyzer);
        HibernateSearchConcurrentMergeScheduler mergeScheduler = new HibernateSearchConcurrentMergeScheduler(this.indexName, this.eventContext.render(), this.threadProvider, this.failureHandler);
        writerConfig.setMergeScheduler((MergeScheduler)mergeScheduler);
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return writerConfig;
    }
}

