/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneEnsureIndexExistsWriteWorkSet;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkSet;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;

public class LuceneBatchingWriteWorkOrchestrator
extends AbstractWorkOrchestrator<LuceneWriteWorkSet>
implements LuceneWriteWorkOrchestratorImplementor {
    private static final int MAX_WORKSETS_PER_BATCH = 1000;
    private final ThreadPoolProvider threadPoolProvider;
    private final BatchingExecutor<LuceneWriteWorkSet, LuceneWriteWorkProcessor> executor;

    public LuceneBatchingWriteWorkOrchestrator(String name, LuceneWriteWorkProcessor processor, ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler) {
        super(name);
        this.threadPoolProvider = threadPoolProvider;
        this.executor = new BatchingExecutor(name, (BatchingExecutor.WorkProcessor)processor, 1000, true, failureHandler);
    }

    @Override
    public CompletableFuture<?> ensureIndexExists() {
        CompletableFuture future = new CompletableFuture();
        this.submit(new LuceneEnsureIndexExistsWriteWorkSet(future));
        return future;
    }

    protected void doStart() {
        this.executor.start(this.threadPoolProvider);
    }

    protected void doSubmit(LuceneWriteWorkSet workSet) throws InterruptedException {
        this.executor.submit((BatchingExecutor.WorkSet)workSet);
    }

    protected CompletableFuture<?> getCompletion() {
        return this.executor.getCompletion();
    }

    protected void doStop() {
        this.executor.stop();
    }
}

