/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkSet;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;

class LuceneSingleWriteWorkSet<T>
implements LuceneWriteWorkSet {
    private final LuceneWriteWork<T> work;
    private final CompletableFuture<T> future;
    private final DocumentCommitStrategy commitStrategy;
    private final DocumentRefreshStrategy refreshStrategy;

    LuceneSingleWriteWorkSet(LuceneWriteWork<T> work, CompletableFuture<T> future, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.work = work;
        this.future = future;
        this.commitStrategy = commitStrategy;
        this.refreshStrategy = refreshStrategy;
    }

    public void submitTo(LuceneWriteWorkProcessor processor) {
        processor.beforeWorkSet(this.commitStrategy, this.refreshStrategy);
        try {
            T result = processor.submit(this.work);
            processor.afterSuccessfulWorkSet();
            this.future.complete(result);
        }
        catch (RuntimeException e) {
            this.markAsFailed(e);
        }
    }

    public void markAsFailed(Throwable t) {
        this.future.completeExceptionally(t);
    }
}

