/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkExecutionContextImpl;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.IndexFailureContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneWriteWorkProcessor
implements BatchingExecutor.WorkProcessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final EventContext eventContext;
    private final IndexAccessor indexAccessor;
    private final LuceneWriteWorkExecutionContextImpl context;
    private final FailureHandler failureHandler;
    private List<LuceneWriteWork<?>> previousWorkSetsUncommittedWorks = new ArrayList();
    private boolean workSetForcesCommit;
    private boolean workSetForcesRefresh;
    private List<LuceneWriteWork<?>> workSetUncommittedWorks = new ArrayList();
    private boolean workSetHasFailure;

    public LuceneWriteWorkProcessor(String indexName, EventContext eventContext, IndexAccessor indexAccessor, FailureHandler failureHandler) {
        this.indexName = indexName;
        this.eventContext = eventContext;
        this.indexAccessor = indexAccessor;
        this.context = new LuceneWriteWorkExecutionContextImpl(eventContext, indexAccessor);
        this.failureHandler = failureHandler;
    }

    public void beginBatch() {
    }

    public CompletableFuture<?> endBatch() {
        if (!this.previousWorkSetsUncommittedWorks.isEmpty()) {
            try {
                this.tryCommitOrDelay();
            }
            catch (RuntimeException e) {
                this.cleanUpAfterFailure(e, "Commit after a batch of index works");
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public long completeOrDelay() {
        if (this.previousWorkSetsUncommittedWorks.isEmpty()) {
            return 0L;
        }
        try {
            return this.tryCommitOrDelay();
        }
        catch (RuntimeException e) {
            this.cleanUpAfterFailure(e, "Commit after completion of all remaining index works");
            return 0L;
        }
    }

    public void beforeWorkSet(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.workSetForcesCommit = DocumentCommitStrategy.FORCE.equals((Object)commitStrategy);
        this.workSetForcesRefresh = DocumentRefreshStrategy.FORCE.equals((Object)refreshStrategy);
        this.workSetUncommittedWorks.clear();
        this.workSetHasFailure = false;
    }

    void ensureIndexExists() {
        this.indexAccessor.ensureIndexExists();
    }

    public <T> T submit(LuceneWriteWork<T> work) {
        if (this.workSetHasFailure) {
            throw new AssertionFailure("A work was submitted to the processor after a failure occurred in the current workset. There is a bug in Hibernate Search, please report it.");
        }
        try {
            this.workSetUncommittedWorks.add(work);
            return work.execute(this.context);
        }
        catch (RuntimeException e) {
            this.cleanUpAfterFailure(e, work.getInfo());
            throw e;
        }
    }

    public void afterSuccessfulWorkSet() {
        if (this.workSetForcesCommit) {
            try {
                this.indexAccessor.commit();
                this.previousWorkSetsUncommittedWorks.clear();
            }
            catch (RuntimeException e) {
                this.cleanUpAfterFailure(e, "Commit after a set of index works");
                throw e;
            }
            finally {
                this.workSetUncommittedWorks.clear();
            }
        }
        this.previousWorkSetsUncommittedWorks.addAll(this.workSetUncommittedWorks);
        this.workSetUncommittedWorks.clear();
        if (this.workSetForcesRefresh) {
            this.indexAccessor.refresh();
        }
    }

    private long tryCommitOrDelay() {
        long timeToCommit = this.indexAccessor.commitOrDelay();
        if (timeToCommit == 0L) {
            this.previousWorkSetsUncommittedWorks.clear();
        }
        return timeToCommit;
    }

    private void cleanUpAfterFailure(Throwable throwable, Object failingOperation) {
        try {
            this.indexAccessor.reset();
        }
        catch (IOException | RuntimeException e) {
            throwable.addSuppressed((Throwable)log.unableToCleanUpAfterError(this.eventContext, e));
        }
        if (this.previousWorkSetsUncommittedWorks.isEmpty()) {
            return;
        }
        IndexFailureContext.Builder failureContextBuilder = IndexFailureContext.builder();
        failureContextBuilder.indexName(this.indexName);
        failureContextBuilder.throwable(throwable);
        failureContextBuilder.failingOperation(failingOperation);
        for (LuceneWriteWork<?> work : this.previousWorkSetsUncommittedWorks) {
            failureContextBuilder.uncommittedOperation(work.getInfo());
        }
        this.previousWorkSetsUncommittedWorks.clear();
        IndexFailureContext failureContext = failureContextBuilder.build();
        this.failureHandler.handle(failureContext);
    }
}

