/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.DocumentReferenceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class LuceneDocumentReferenceProjection
implements LuceneSearchProjection<DocumentReference, DocumentReference> {
    private final Set<String> indexNames;

    public LuceneDocumentReferenceProjection(Set<String> indexNames) {
        this.indexNames = indexNames;
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireCollector(DocumentReferenceCollector.FACTORY);
    }

    @Override
    public DocumentReference extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return context.getCollector(DocumentReferenceCollector.KEY).get(documentResult.getDocId());
    }

    @Override
    public DocumentReference transform(LoadingResult<?> loadingResult, DocumentReference extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

