/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneLongDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.cfg.spi.NumberScaleConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneBigDecimalFieldCodec
extends AbstractLuceneNumericFieldCodec<BigDecimal, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final int decimalScale;
    private final BigDecimal minScaledValue;
    private final BigDecimal maxScaledValue;

    public LuceneBigDecimalFieldCodec(boolean projectable, boolean searchable, boolean sortable, boolean aggregable, BigDecimal indexNullAsValue, int decimalScale) {
        super(projectable, searchable, sortable, aggregable, indexNullAsValue);
        this.decimalScale = decimalScale;
        this.minScaledValue = new BigDecimal(NumberScaleConstants.MIN_LONG_AS_BIGINTEGER, decimalScale);
        this.maxScaledValue = new BigDecimal(NumberScaleConstants.MAX_LONG_AS_BIGINTEGER, decimalScale);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, BigDecimal value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, value.toString()));
    }

    @Override
    public BigDecimal decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return new BigDecimal(field.stringValue());
    }

    @Override
    public Long encode(BigDecimal value) {
        if (this.isTooLarge(value)) {
            throw log.scaledNumberTooLarge(value);
        }
        return this.unscale(value);
    }

    @Override
    public BigDecimal decode(Long encoded) {
        return this.scale(encoded);
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneLongDomain.get();
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (!super.isCompatibleWith(obj)) {
            return false;
        }
        LuceneBigDecimalFieldCodec other = (LuceneBigDecimalFieldCodec)obj;
        return this.decimalScale == other.decimalScale;
    }

    private Long unscale(BigDecimal value) {
        return value.setScale(this.decimalScale, RoundingMode.HALF_UP).unscaledValue().longValue();
    }

    private BigDecimal scale(Long value) {
        return new BigDecimal(BigInteger.valueOf(value), this.decimalScale);
    }

    private boolean isTooLarge(BigDecimal value) {
        return value.compareTo(this.minScaledValue) < 0 || value.compareTo(this.maxScaledValue) > 0;
    }
}

