/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneFloatDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneFloatFieldCodec
extends AbstractLuceneNumericFieldCodec<Float, Float> {
    public LuceneFloatFieldCodec(boolean projectable, boolean searchable, boolean sortable, boolean aggregable, Float indexNullAsValue) {
        super(projectable, searchable, sortable, aggregable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Float value, Float encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.floatValue()));
    }

    @Override
    public Float decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return (Float)field.numericValue();
    }

    @Override
    public Float encode(Float value) {
        return value;
    }

    @Override
    public Float decode(Float encoded) {
        return encoded;
    }

    @Override
    public LuceneNumericDomain<Float> getDomain() {
        return LuceneFloatDomain.get();
    }
}

