/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.util.common.impl.Contracts;

abstract class AbstractLuceneIndexFieldTypeOptionsStep<S extends AbstractLuceneIndexFieldTypeOptionsStep<?, F>, F>
implements IndexFieldTypeOptionsStep<S, F> {
    private final Class<F> fieldType;
    private DslConverter<?, ? extends F> dslConverter;
    private ProjectionConverter<? super F, ?> projectionConverter;

    AbstractLuceneIndexFieldTypeOptionsStep(Class<F> fieldType) {
        this.fieldType = fieldType;
    }

    public <V> S dslConverter(Class<V> valueType, ToDocumentFieldValueConverter<V, ? extends F> toIndexConverter) {
        Contracts.assertNotNull(toIndexConverter, (String)"toIndexConverter");
        this.dslConverter = new DslConverter(valueType, toIndexConverter);
        return this.thisAsS();
    }

    public <V> S projectionConverter(Class<V> valueType, FromDocumentFieldValueConverter<? super F, V> fromIndexConverter) {
        Contracts.assertNotNull(fromIndexConverter, (String)"fromIndexConverter");
        this.projectionConverter = new ProjectionConverter(valueType, fromIndexConverter);
        return this.thisAsS();
    }

    protected abstract S thisAsS();

    final DslConverter<?, ? extends F> createDslConverter() {
        return this.dslConverter == null ? this.createRawDslConverter() : this.dslConverter;
    }

    final DslConverter<F, ? extends F> createRawDslConverter() {
        return new DslConverter(this.fieldType, (ToDocumentFieldValueConverter)new PassThroughToDocumentFieldValueConverter());
    }

    final ProjectionConverter<? super F, ?> createProjectionConverter() {
        return this.projectionConverter == null ? this.createRawProjectionConverter() : this.projectionConverter;
    }

    final ProjectionConverter<? super F, F> createRawProjectionConverter() {
        return new ProjectionConverter(this.fieldType, (FromDocumentFieldValueConverter)new PassThroughFromDocumentFieldValueConverter());
    }
}

