/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBigIntegerFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneNumericIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneBigIntegerIndexFieldTypeOptionsStep
extends AbstractLuceneNumericIndexFieldTypeOptionsStep<LuceneBigIntegerIndexFieldTypeOptionsStep, BigInteger>
implements ScaledNumberIndexFieldTypeOptionsStep<LuceneBigIntegerIndexFieldTypeOptionsStep, BigInteger> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    LuceneBigIntegerIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigInteger.class);
        this.defaultsProvider = defaultsProvider;
    }

    public LuceneBigIntegerIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this;
    }

    @Override
    protected LuceneBigIntegerIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    @Override
    protected AbstractLuceneNumericFieldCodec<BigInteger, ?> createCodec(boolean resolvedProjectable, boolean resolvedSearchable, boolean resolvedSortable, boolean resolvedAggregable, BigInteger indexNullAsValue) {
        int resolvedDecimalScale = this.resolveDecimalScale();
        if (resolvedDecimalScale > 0) {
            throw log.invalidDecimalScale(resolvedDecimalScale, this.getBuildContext().getEventContext());
        }
        return new LuceneBigIntegerFieldCodec(resolvedProjectable, resolvedSearchable, resolvedSortable, resolvedAggregable, indexNullAsValue, resolvedDecimalScale);
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.getDecimalScale() != null) {
            return this.defaultsProvider.getDecimalScale();
        }
        throw log.nullDecimalScale(this.getBuildContext().getEventContext());
    }
}

