/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneTextFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStringFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneTextFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneStringIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneStringIndexFieldTypeOptionsStep, String>
implements StringIndexFieldTypeOptionsStep<LuceneStringIndexFieldTypeOptionsStep> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private Analyzer analyzer;
    private String searchAnalyzerName;
    private Analyzer searchAnalyzer;
    private String normalizerName;
    private Analyzer normalizer;
    private Norms norms = Norms.DEFAULT;
    private TermVector termVector = TermVector.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;

    LuceneStringIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public LuceneStringIndexFieldTypeOptionsStep analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        this.analyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(analyzerName);
        if (this.analyzer == null) {
            throw log.unknownAnalyzer(analyzerName, this.getBuildContext().getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep searchAnalyzer(String searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        this.searchAnalyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(searchAnalyzerName);
        if (this.searchAnalyzer == null) {
            throw log.unknownAnalyzer(searchAnalyzerName, this.getBuildContext().getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        this.normalizer = this.getAnalysisDefinitionRegistry().getNormalizerDefinition(normalizerName);
        if (this.normalizer == null) {
            throw log.unknownNormalizer(normalizerName, this.getBuildContext().getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep norms(Norms norms) {
        this.norms = norms;
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep termVector(TermVector termVector) {
        this.termVector = termVector;
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<String> toIndexFieldType() {
        boolean resolvedSortable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedAggregable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        boolean resolvedNorms = this.resolveNorms();
        ResolvedTermVector resolvedTermVector = this.resolveTermVector();
        if (this.analyzer != null) {
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
            if (this.normalizer != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.getBuildContext().getEventContext());
            }
            if (this.indexNullAsValue != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, (String)this.indexNullAsValue, this.getBuildContext().getEventContext());
            }
            if (resolvedAggregable) {
                throw log.cannotUseAnalyzerOnAggregableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
        } else if (this.searchAnalyzer != null) {
            throw log.searchAnalyzerWithoutAnalyzer(this.searchAnalyzerName, this.getBuildContext().getEventContext());
        }
        Analyzer analyzerOrNormalizer = this.analyzer != null ? this.analyzer : this.normalizer;
        DslConverter dslConverter = this.createDslConverter();
        DslConverter rawDslConverter = this.createRawDslConverter();
        ProjectionConverter projectionConverter = this.createProjectionConverter();
        ProjectionConverter rawProjectionConverter = this.createRawProjectionConverter();
        LuceneStringFieldCodec codec = new LuceneStringFieldCodec(resolvedSearchable, resolvedSortable, resolvedAggregable, LuceneStringIndexFieldTypeOptionsStep.getFieldType(resolvedProjectable, resolvedSearchable, this.analyzer != null, resolvedNorms, resolvedTermVector), (String)this.indexNullAsValue, analyzerOrNormalizer);
        return new LuceneIndexFieldType<String>(codec, new LuceneTextFieldPredicateBuilderFactory<String>(resolvedSearchable, dslConverter, rawDslConverter, codec, this.searchAnalyzer != null ? this.searchAnalyzer : analyzerOrNormalizer), new LuceneTextFieldSortBuilderFactory<String>(resolvedSortable, (DslConverter<?, String>)dslConverter, (DslConverter<String, String>)rawDslConverter, codec), new LuceneStandardFieldProjectionBuilderFactory<String>(resolvedProjectable, projectionConverter, rawProjectionConverter, codec), new LuceneTextFieldAggregationBuilderFactory(resolvedAggregable, dslConverter, rawDslConverter, projectionConverter, rawProjectionConverter, codec, this.analyzer != null), resolvedAggregable, analyzerOrNormalizer);
    }

    @Override
    protected LuceneStringIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.getBuildContext().getAnalysisDefinitionRegistry();
    }

    private boolean resolveNorms() {
        switch (this.norms) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case DEFAULT: {
                return this.analyzerName != null;
            }
        }
        throw new AssertionFailure("Unexpected value for Norms: " + this.norms);
    }

    private ResolvedTermVector resolveTermVector() {
        switch (this.termVector) {
            case NO: 
            case DEFAULT: {
                return new ResolvedTermVector(false, false, false, false);
            }
            case YES: {
                return new ResolvedTermVector(true, false, false, false);
            }
            case WITH_POSITIONS: {
                return new ResolvedTermVector(true, true, false, false);
            }
            case WITH_OFFSETS: {
                return new ResolvedTermVector(true, false, true, false);
            }
            case WITH_POSITIONS_OFFSETS: {
                return new ResolvedTermVector(true, true, true, false);
            }
            case WITH_POSITIONS_PAYLOADS: {
                return new ResolvedTermVector(true, true, false, true);
            }
            case WITH_POSITIONS_OFFSETS_PAYLOADS: {
                return new ResolvedTermVector(true, true, true, true);
            }
        }
        throw new AssertionFailure("Unexpected value for TermVector: " + this.termVector);
    }

    private static FieldType getFieldType(boolean projectable, boolean searchable, boolean analyzed, boolean norms, ResolvedTermVector termVector) {
        FieldType fieldType = new FieldType();
        if (!searchable) {
            fieldType.setIndexOptions(IndexOptions.NONE);
            fieldType.setStored(projectable);
            fieldType.freeze();
            return fieldType;
        }
        if (analyzed) {
            fieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            termVector.applyTo(fieldType);
            fieldType.setTokenized(true);
        } else {
            fieldType.setIndexOptions(IndexOptions.DOCS);
            fieldType.setTokenized(true);
        }
        fieldType.setStored(projectable);
        fieldType.setOmitNorms(!norms);
        fieldType.freeze();
        return fieldType;
    }

    private static final class ResolvedTermVector {
        private final boolean store;
        private final boolean positions;
        private final boolean offsets;
        private final boolean payloads;

        private ResolvedTermVector(boolean store, boolean positions, boolean offsets, boolean payloads) {
            this.store = store;
            this.positions = positions;
            this.offsets = offsets;
            this.payloads = payloads;
        }

        private void applyTo(FieldType fieldType) {
            fieldType.setStoreTermVectors(this.store);
            fieldType.setStoreTermVectorPositions(this.positions);
            fieldType.setStoreTermVectorOffsets(this.offsets);
            fieldType.setStoreTermVectorPayloads(this.payloads);
        }
    }
}

