/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneTextFieldComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneStandardFieldSortBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;

public class LuceneTextFieldSortBuilder<F>
extends AbstractLuceneStandardFieldSortBuilder<F, String, LuceneTextFieldCodec<F>> {
    LuceneTextFieldSortBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, String nestedDocumentPath, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, LuceneTextFieldCodec<F> codec) {
        super(searchContext, absoluteFieldPath, nestedDocumentPath, converter, rawConverter, converterChecker, codec, SortField.STRING_FIRST, SortField.STRING_LAST);
    }

    @Override
    protected Object encodeMissingAs(F converted) {
        return ((LuceneTextFieldCodec)this.codec).normalize(this.absoluteFieldPath, (String)((LuceneTextFieldCodec)this.codec).encode(converted));
    }

    @Override
    public void buildAndContribute(LuceneSearchSortCollector collector) {
        LuceneTextFieldComparatorSource fieldComparatorSource = new LuceneTextFieldComparatorSource(this.nestedDocumentPath, this.missingValue);
        SortField sortField = new SortField(this.absoluteFieldPath, (FieldComparatorSource)fieldComparatorSource, this.order == SortOrder.DESC);
        collector.collectSortField(sortField, this.nestedDocumentPath != null ? fieldComparatorSource : null);
    }
}

