/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneDeleteEntriesByQueryWork
extends AbstractLuceneWriteWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Query query;

    LuceneDeleteEntriesByQueryWork(Query query) {
        super("deleteByQuery");
        this.query = query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append("query=").append(this.query).append("]");
        return sb.toString();
    }

    @Override
    public Long execute(LuceneWriteWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexWriterDelegator();
            return indexWriterDelegator.deleteDocuments(this.query);
        }
        catch (IOException e) {
            throw log.unableToDeleteAllEntriesFromIndex(this.query, context.getEventContext(), e);
        }
    }
}

