/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.util.ArrayList;
import java.util.Set;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.LuceneAddEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneCountWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneDeleteEntriesByQueryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneDeleteEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneExplainWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneMergeSegmentsWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneNoOpWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearchWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneSingleDocumentWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneUpdateEntryWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;

public class LuceneWorkFactoryImpl
implements LuceneWorkFactory {
    private final MultiTenancyStrategy multiTenancyStrategy;

    public LuceneWorkFactoryImpl(MultiTenancyStrategy multiTenancyStrategy) {
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    @Override
    public LuceneSingleDocumentWriteWork<?> add(String tenantId, String id, LuceneIndexEntry indexEntry) {
        return new LuceneAddEntryWork(tenantId, id, indexEntry);
    }

    @Override
    public LuceneSingleDocumentWriteWork<?> update(String tenantId, String id, LuceneIndexEntry indexEntry) {
        Query filter = this.multiTenancyStrategy.getFilterOrNull(tenantId);
        return new LuceneUpdateEntryWork(tenantId, id, filter, indexEntry);
    }

    @Override
    public LuceneSingleDocumentWriteWork<?> delete(String tenantId, String id) {
        Query filter = this.multiTenancyStrategy.getFilterOrNull(tenantId);
        return new LuceneDeleteEntryWork(tenantId, id, filter);
    }

    @Override
    public LuceneWriteWork<?> deleteAll(String tenantId, Set<String> routingKeys) {
        ArrayList<Query> filters = new ArrayList<Query>();
        Query filter = this.multiTenancyStrategy.getFilterOrNull(tenantId);
        if (filter != null) {
            filters.add(filter);
        }
        if (!routingKeys.isEmpty()) {
            filters.add(Queries.anyTerm(MetadataFields.routingKeyFieldName(), routingKeys));
        }
        return new LuceneDeleteEntriesByQueryWork(Queries.boolFilter((Query)new MatchAllDocsQuery(), filters));
    }

    @Override
    public LuceneWriteWork<?> noOp() {
        return new LuceneNoOpWriteWork();
    }

    @Override
    public LuceneWriteWork<?> mergeSegments() {
        return new LuceneMergeSegmentsWork();
    }

    @Override
    public <R> LuceneReadWork<R> search(LuceneSearcher<R> searcher, Integer offset, Integer limit) {
        return new LuceneSearchWork<R>(searcher, offset, limit);
    }

    @Override
    public LuceneReadWork<Integer> count(LuceneSearcher<?> searcher) {
        return new LuceneCountWork(searcher);
    }

    @Override
    public LuceneReadWork<Explanation> explain(LuceneSearcher<?> searcher, String explainedDocumentIndexName, String explainedDocumentId, Query explainedDocumentFilter) {
        return new LuceneExplainWork(searcher, explainedDocumentIndexName, explainedDocumentId, explainedDocumentFilter);
    }
}

