package org.hibernate.search.backend.lucene.logging.impl;

import java.util.Locale;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import java.io.Serializable;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.jboss.logging.Logger;
import java.lang.Number;
import org.apache.lucene.util.Version;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.jboss.logging.BasicLogger;
import java.util.List;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.apache.lucene.store.Directory;
import java.nio.file.Path;
import java.time.Duration;
import java.io.IOException;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import java.lang.Integer;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.engine.search.projection.SearchProjection;
import java.util.Collection;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(final Path absolutePath) {
        super.log.logf(FQCN, INFO, null, indexDirectoryNotFoundCreatingNewOne$str(), absolutePath);
    }
    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return "HSEARCH000041: Index directory not found, creating: '%1$s'";
    }
    @Override
    public final void indexWriterReset(final EventContext context) {
        super.log.logf(FQCN, WARN, null, indexWriterReset$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String indexWriterReset$str() {
        return "HSEARCH000052: Going to reset the index writer and force release of the IndexWriter lock. %1$s";
    }
    @Override
    public final void unableToCloseIndexReader(final EventContext context, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCloseIndexReader$str(), new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String unableToCloseIndexReader$str() {
        return "HSEARCH000055: Unable to close the index reader. %1$s";
    }
    @Override
    public final void recommendConfiguringLuceneVersion(final String key, final Version latest, final EventContext context) {
        super.log.logf(FQCN, WARN, null, recommendConfiguringLuceneVersion$str(), key, latest, new org.hibernate.search.util.common.logging.impl.EventContextFormatter(context));
    }
    protected String recommendConfiguringLuceneVersion$str() {
        return "HSEARCH000075: Configuration setting '%1$s' was not specified: using LATEST (currently '%2$s'). %3$s";
    }
    protected String unableToLoadResource$str() {
        return "HSEARCH000114: Could not load resource: '%1$s'";
    }
    @Override
    public final SearchException unableToLoadResource(final String fileName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToLoadResource$str(), fileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String indexMergeOperation$str() {
        return "HSEARCH000118: Index Merge operation on index '%1$s'";
    }
    @Override
    public final String indexMergeOperation(final String indexName) {
        return String.format(getLoggingLocale(), indexMergeOperation$str(), indexName);
    }
    @Override
    public final void lockingFailureDuringInitialization(final String directoryDescription, final EventContext context) {
        super.log.logf(FQCN, WARN, null, lockingFailureDuringInitialization$str(), directoryDescription);
    }
    protected String lockingFailureDuringInitialization$str() {
        return "HSEARCH000225: An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.";
    }
    @Override
    public final void logInfoStreamMessage(final String componentName, final String message) {
        super.log.logf(FQCN, TRACE, null, logInfoStreamMessage$str(), componentName, message);
    }
    protected String logInfoStreamMessage$str() {
        return "HSEARCH000226: %s: %s";
    }
    protected String illegalLuceneVersionFormat$str() {
        return "HSEARCH000228: Value '%1$ss' is not in a valid format to express a Lucene version: %2$s";
    }
    @Override
    public final SearchException illegalLuceneVersionFormat(final String property, final String luceneErrorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalLuceneVersionFormat$str(), property, luceneErrorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void executingLuceneQuery(final Query luceneQuery) {
        super.log.logf(FQCN, DEBUG, null, executingLuceneQuery$str(), luceneQuery);
    }
    protected String executingLuceneQuery$str() {
        return "HSEARCH000274: Executing Lucene query '%s'";
    }
    protected String failureOnMultiReaderRefresh$str() {
        return "HSEARCH000284: An exception occurred while opening multiple indexes.";
    }
    @Override
    public final SearchException failureOnMultiReaderRefresh(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failureOnMultiReaderRefresh$str()), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotNormalizeField$str() {
        return "HSEARCH000320: Could not normalize value for field '%1$s'.";
    }
    @Override
    public final SearchException couldNotNormalizeField(final String absoluteFieldPath, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), couldNotNormalizeField$str(), absoluteFieldPath), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void multipleTermsDetectedDuringNormalization(final String absoluteFieldPath) {
        super.log.logf(FQCN, WARN, null, multipleTermsDetectedDuringNormalization$str(), absoluteFieldPath);
    }
    protected String multipleTermsDetectedDuringNormalization$str() {
        return "HSEARCH000321: The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields or range queries. Only the first token will be considered.";
    }
    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH000329: Error while applying analysis configuration: %1$s";
    }
    @Override
    public final SearchException unableToApplyAnalysisConfiguration(final String errorMessage, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToApplyAnalysisConfiguration$str(), errorMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String analyzerDefinitionNamingConflict$str() {
        return "HSEARCH000330: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    }
    @Override
    public final SearchException analyzerDefinitionNamingConflict(final String analyzerDefinitionName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analyzerDefinitionNamingConflict$str(), analyzerDefinitionName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH000337: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }
    @Override
    public final SearchException analysisComponentParameterConflict(final String name, final String value1, final String value2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), analysisComponentParameterConflict$str(), name, value1, value2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String normalizerDefinitionNamingConflict$str() {
        return "HSEARCH000341: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    }
    @Override
    public final SearchException normalizerDefinitionNamingConflict(final String normalizerDefinitionName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), normalizerDefinitionNamingConflict$str(), normalizerDefinitionName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH000342: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    }
    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(final String analyzerName, final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void normalizerProducedMultipleTokens(final String normalizerName, final int token) {
        super.log.logf(FQCN, WARN, null, normalizerProducedMultipleTokens$str(), normalizerName, token);
    }
    protected String normalizerProducedMultipleTokens$str() {
        return "HSEARCH000344: The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.";
    }
    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH000345: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAnalyzer$str() {
        return "HSEARCH000353: Unknown analyzer: '%1$s'. Make sure you defined this analyzer.";
    }
    @Override
    public final SearchException unknownAnalyzer(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownAnalyzer$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForSearch$str() {
        return "HSEARCH600000: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForSearch(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForSearch$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathIsNotWriteableDirectory$str() {
        return "HSEARCH600001: Path '%1$s' exists but does not point to a writable directory.";
    }
    @Override
    public final SearchException pathIsNotWriteableDirectory(final Path rootDirectory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), pathIsNotWriteableDirectory$str(), rootDirectory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInitializeRootDirectory$str() {
        return "HSEARCH600002: Unable to initialize root directory '%1$s': %2$s";
    }
    @Override
    public final SearchException unableToInitializeRootDirectory(final Path rootDirectory, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInitializeRootDirectory$str(), rootDirectory, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String luceneExtensionOnUnknownType$str() {
        return "HSEARCH600005: The Lucene extension can only be applied to objects derived from the Lucene backend. Was applied to '%1$s' instead.";
    }
    @Override
    public final SearchException luceneExtensionOnUnknownType(final Object context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), luceneExtensionOnUnknownType$str(), context));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherPredicates$str() {
        return "HSEARCH600010: A Lucene query cannot include search predicates built using a non-Lucene search scope. Given predicate was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherPredicates(final SearchPredicate predicate) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherPredicates$str(), predicate));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonObjectFieldForNestedQuery$str() {
        return "HSEARCH600012: Field '%1$s' is not an object field.";
    }
    @Override
    public final SearchException nonObjectFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonNestedFieldForNestedQuery$str() {
        return "HSEARCH600013: Object field '%1$s' is not stored as nested.";
    }
    @Override
    public final SearchException nonNestedFieldForNestedQuery(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchSortWithOtherSorts$str() {
        return "HSEARCH600014: A Lucene query cannot include search sorts built using a non-Lucene search scope. Given sort was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixLuceneSearchSortWithOtherSorts(final SearchSort sort) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchSortWithOtherSorts$str(), sort));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInitializeIndexDirectory$str() {
        return "HSEARCH600015: Unable to initialize index directory: %1$s";
    }
    @Override
    public final SearchException unableToInitializeIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInitializeIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToIndexEntry$str() {
        return "HSEARCH600016: Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s'.";
    }
    @Override
    public final SearchException unableToIndexEntry(final String tenantId, final String entityTypeName, final Object entityIdentifier, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToIndexEntry$str(), tenantId, entityTypeName, entityIdentifier), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDeleteEntryFromIndex$str() {
        return "HSEARCH600017: Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s'.";
    }
    @Override
    public final SearchException unableToDeleteEntryFromIndex(final String tenantId, final String entityTypeName, final Object entityIdentifier, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteEntryFromIndex$str(), tenantId, entityTypeName, entityIdentifier), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFlushIndex$str() {
        return "HSEARCH600018: Unable to flush.";
    }
    @Override
    public final SearchException unableToFlushIndex(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToFlushIndex$str()), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCommitIndex$str() {
        return "HSEARCH600019: Unable to commit.";
    }
    @Override
    public final SearchException unableToCommitIndex(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCommitIndex$str()), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToRefreshIndex$str() {
        return "HSEARCH600022: Unable to refresh.";
    }
    @Override
    public final SearchException unableToRefreshIndex(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToRefreshIndex$str()), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneScopeWithOtherType$str() {
        return "HSEARCH600024: A multi-index scope cannot include both a Lucene index and another type of index. Base scope was: '%1$s', Lucene index was: '%2$s'";
    }
    @Override
    public final SearchException cannotMixLuceneScopeWithOtherType(final IndexScopeBuilder baseScope, final LuceneIndexManager luceneIndex, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneScopeWithOtherType$str(), baseScope, luceneIndex), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneScopeWithOtherBackend$str() {
        return "HSEARCH600025: A multi-index scope cannot span multiple Lucene backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    }
    @Override
    public final SearchException cannotMixLuceneScopeWithOtherBackend(final IndexScopeBuilder baseScope, final LuceneIndexManager indexFromOtherBackend, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ioExceptionOnQueryExecution$str() {
        return "HSEARCH600027: An IOException happened while executing the query '%1$s'.";
    }
    @Override
    public final SearchException ioExceptionOnQueryExecution(final Query luceneQuery, final EventContext context, final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnQueryExecution$str(), luceneQuery), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return "HSEARCH600029: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    }
    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(final String indexName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH600030: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidMultiTenancyStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH600031: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    }
    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(final String tenantId, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH600032: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    }
    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multiTenancyEnabledButNoTenantIdProvided$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH600033: Attempt to unwrap a Lucene backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException backendUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH600034: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaNodeNameConflict(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaNodeNameConflict$str(), relativeFieldName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangesNotSupportedByGeoPoint$str() {
        return "HSEARCH600037: Range lookups (range predicates, range aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }
    @Override
    public final SearchException rangesNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangesNotSupportedByGeoPoint$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String directValueLookupNotSupportedByGeoPoint$str() {
        return "HSEARCH600038: Direct value lookups (match predicates, terms aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }
    @Override
    public final SearchException directValueLookupNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), directValueLookupNotSupportedByGeoPoint$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH600039: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldForDocumentElement(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH600040: Spatial predicates are not supported by this field's type.";
    }
    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), spatialPredicatesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String distanceOperationsNotSupportedByFieldType$str() {
        return "HSEARCH600041: Distance related operations are not supported by this field's type.";
    }
    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), distanceOperationsNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return "HSEARCH600042: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    }
    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), traditionalSortNotSupportedByGeoPoint$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchMinimumOutOfBounds$str() {
        return "HSEARCH600044: Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.";
    }
    @Override
    public final SearchException minimumShouldMatchMinimumOutOfBounds(final int totalShouldClauseNumber, final int minimum) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchMinimumOutOfBounds$str(), totalShouldClauseNumber, minimum));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH600045: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }
    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(final int ignoreConstraintCeiling) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), minimumShouldMatchConflictingConstraints$str(), ignoreConstraintCeiling));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedDSLPredicatesForNativeField$str() {
        return "HSEARCH600046: Native fields do not support defining predicates with the DSL: use the Lucene extension and a native query.";
    }
    @Override
    public final SearchException unsupportedDSLPredicatesForNativeField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedDSLPredicatesForNativeField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedDSLSortsForNativeField$str() {
        return "HSEARCH600047: Native fields do not support defining sorts with the DSL: use the Lucene extension and a native sort.";
    }
    @Override
    public final SearchException unsupportedDSLSortsForNativeField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedDSLSortsForNativeField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedProjectionForNativeField$str() {
        return "HSEARCH600048: This native field does not support projection.";
    }
    @Override
    public final SearchException unsupportedProjectionForNativeField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedProjectionForNativeField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldPath$str() {
        return "HSEARCH600049: Invalid field path; expected path '%1$s', got '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldPath(final String expectedPath, final String actualPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldPath$str(), expectedPath, actualPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertDslParameter$str() {
        return "HSEARCH600050: Unable to convert DSL parameter: %1$s";
    }
    @Override
    public final SearchException cannotConvertDslParameter(final String errorMessage, final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConvertDslParameter$str(), errorMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH600051: Attempt to unwrap a Lucene index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    }
    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(final Class<?> requestedClass, final Class<?> actualClass, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexManagerUnwrappingWithUnknownType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(requestedClass), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualClass)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAnalyzer$str() {
        return "HSEARCH600052: Unable to create analyzer for name '%1$s'.";
    }
    @Override
    public final SearchException unableToCreateAnalyzer(final String name, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateAnalyzer$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateNormalizer$str() {
        return "HSEARCH600053: Unable to create normalizer for name '%1$s'.";
    }
    @Override
    public final SearchException unableToCreateNormalizer(final String name, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCreateNormalizer$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNormalizer$str() {
        return "HSEARCH600054: Unknown normalizer: '%1$s'. Make sure you defined this normalizer.";
    }
    @Override
    public final SearchException unknownNormalizer(final String normalizerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNormalizer$str(), normalizerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherProjections$str() {
        return "HSEARCH600055: A Lucene query cannot include search projections built using a non-Lucene search scope. Given projection was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherProjections(final SearchProjection<?> projection) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherProjections$str(), projection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProjectionInvalidType$str() {
        return "HSEARCH600056: Invalid type '%2$s' for projection on field '%1$s'.";
    }
    @Override
    public final SearchException invalidProjectionInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidProjectionInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForPredicate$str() {
        return "HSEARCH600058: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForPredicate(final String absoluteFieldPath, final LuceneFieldPredicateBuilderFactory component1, final LuceneFieldPredicateBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForSort$str() {
        return "HSEARCH600059: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForSort(final String absoluteFieldPath, final LuceneFieldSortBuilderFactory component1, final LuceneFieldSortBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForProjection$str() {
        return "HSEARCH600060: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForProjection(final String absoluteFieldPath, final LuceneFieldProjectionBuilderFactory component1, final LuceneFieldProjectionBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToShutdownBackend$str() {
        return "HSEARCH600061: Failed to shut down the Lucene index manager.";
    }
    @Override
    public final SearchException failedToShutdownBackend(final Exception cause, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), failedToShutdownBackend$str()), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotGuessFieldType$str() {
        return "HSEARCH600062: Cannot guess field type for input type: '%1$s'.";
    }
    @Override
    public final SearchException cannotGuessFieldType(final Class<?> inputType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotGuessFieldType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(inputType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String documentIdNotCollected$str() {
        return "HSEARCH600064: Unexpected index: documentId '%1$s' was not collected.";
    }
    @Override
    public final SearchException documentIdNotCollected(final Integer documentId) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), documentIdNotCollected$str(), documentId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonProjectableField$str() {
        return "HSEARCH600065: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    }
    @Override
    public final SearchException nonProjectableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonProjectableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsortableField$str() {
        return "HSEARCH600066: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    }
    @Override
    public final SearchException unsortableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsortableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDeleteAllEntriesFromIndex$str() {
        return "HSEARCH600067: Unable to delete all entries matching query '%1$s'.";
    }
    @Override
    public final SearchException unableToDeleteAllEntriesFromIndex(final Query query, final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDeleteAllEntriesFromIndex$str(), query), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingIdentifierTypesForPredicate$str() {
        return "HSEARCH600068: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    }
    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(final ToDocumentIdentifierValueConverter<?> component1, final ToDocumentIdentifierValueConverter<?> component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ioExceptionOnExplain$str() {
        return "HSEARCH600069: An IOException occurred while generating an Explanation.";
    }
    @Override
    public final SearchException ioExceptionOnExplain(final IOException e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), ioExceptionOnExplain$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String textPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH600070: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    }
    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), textPredicatesNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteFieldDefinition$str() {
        return "HSEARCH600071: Incomplete field definition. You must call toReference() to complete the field definition.";
    }
    @Override
    public final SearchException incompleteFieldDefinition(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), incompleteFieldDefinition$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH600072: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }
    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCreateReferenceMultipleTimes$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH600073: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    }
    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(final String analyzerName, final String indexNullAs, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH600074: Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.";
    }
    @Override
    public final SearchException multipleValuesForSingleValuedField(final String absoluteFieldPath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleValuesForSingleValuedField$str(), absoluteFieldPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeName$str() {
        return "HSEARCH600075: explain(String id) cannot be used when the query targets multiple mapped types. Use explain(String typeName, String id) and pass one of %1$s as the mapped type name.";
    }
    @Override
    public final SearchException explainRequiresTypeName(final Set<String> targetedTypeNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeName$str(), targetedTypeNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainRequiresTypeTargetedByQuery$str() {
        return "HSEARCH600076: The given mapped type name '%2$s' is not among the mapped types targeted by this query: %1$s.";
    }
    @Override
    public final SearchException explainRequiresTypeTargetedByQuery(final Set<String> targetedTypeNames, final String typeName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainRequiresTypeTargetedByQuery$str(), targetedTypeNames, typeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String explainUnkownDocument$str() {
        return "HSEARCH600077: Document with id '%2$s' does not exist for the mapped type '%1$s' and thus its match cannot be explained.";
    }
    @Override
    public final SearchException explainUnkownDocument(final String typeName, final String id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), explainUnkownDocument$str(), typeName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToMergeSegments$str() {
        return "HSEARCH600078: Unable to merge index segments.";
    }
    @Override
    public final SearchException unableToMergeSegments(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToMergeSegments$str()), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCloseIndexWriterAfterFailures$str() {
        return "HSEARCH600079: Unable to close the index writer after write failures.";
    }
    @Override
    public final SearchException unableToCloseIndexWriterAfterFailures(final EventContext context, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToCloseIndexWriterAfterFailures$str()), e, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullDecimalScale$str() {
        return "HSEARCH600080: Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.";
    }
    @Override
    public final SearchException nullDecimalScale(final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nullDecimalScale$str()), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scaledNumberTooLarge$str() {
        return "HSEARCH600081: The value '%1$s' cannot be indexed because its absolute value is too large.";
    }
    @Override
    public final SearchException scaledNumberTooLarge(final Number value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), scaledNumberTooLarge$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidDecimalScale$str() {
        return "HSEARCH600082: Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.";
    }
    @Override
    public final SearchException invalidDecimalScale(final Integer decimalScale, final EventContext eventContext) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidDecimalScale$str(), decimalScale), eventContext);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSearchableField$str() {
        return "HSEARCH600083: Field '%1$s' is not searchable. Make sure the field is marked as searchable.";
    }
    @Override
    public final SearchException nonSearchableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonSearchableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH600084: The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(final SearchPredicate predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH600085: The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException sortDefinedOnDifferentIndexes(final SearchSort predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH600086: The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(final SearchProjection<?> predicate, final Set<String> predicateIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFileSystemAccessStrategyName$str() {
        return "HSEARCH600087: Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidFileSystemAccessStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFileSystemAccessStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidLockingStrategyName$str() {
        return "HSEARCH600088: Invalid locking strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidLockingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLockingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingShardIdentifiersAfterShardingStrategyInitialization$str() {
        return "HSEARCH600089: The sharding strategy '%1$s' is not implemented properly: it must call either context.setShardIdentifiers() or context.setShardingDisabled() in its initialize() method, but it did not.";
    }
    @Override
    public final SearchException missingShardIdentifiersAfterShardingStrategyInitialization(final Object strategy) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingShardIdentifiersAfterShardingStrategyInitialization$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingPropertyValueForShardingStrategy$str() {
        return "HSEARCH600090: Missing value for property '%2$s'. The sharding strategy '%1$s' requires this property to be set.";
    }
    @Override
    public final SearchException missingPropertyValueForShardingStrategy(final String strategyName, final String propertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingPropertyValueForShardingStrategy$str(), strategyName, propertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRoutingKeyForExplicitShardingStrategy$str() {
        return "HSEARCH600091: Invalid routing key: '%1$s'. Valid keys are: %2$s.";
    }
    @Override
    public final SearchException invalidRoutingKeyForExplicitShardingStrategy(final String invalidKey, final Collection<String> validKeys) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidRoutingKeyForExplicitShardingStrategy$str(), invalidKey, validKeys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingNestedDocumentPaths$str() {
        return "HSEARCH600093: Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingNestedDocumentPaths(final String absoluteFieldPath, final String nestedDocumentPath1, final String nestedDocumentPath2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingNestedDocumentPaths$str(), absoluteFieldPath, nestedDocumentPath1, nestedDocumentPath2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH600094: Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }
    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(final String analyzerName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonAggregableField$str() {
        return "HSEARCH600095: Aggregations are not enabled for field '%1$s'. Make sure the field is marked as aggregable.";
    }
    @Override
    public final SearchException nonAggregableField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), nonAggregableField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAggregationInvalidType$str() {
        return "HSEARCH600096: Invalid type '%2$s' for aggregation on field '%1$s'.";
    }
    @Override
    public final SearchException invalidAggregationInvalidType(final String absoluteFieldPath, final Class<?> type, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAggregationInvalidType$str(), absoluteFieldPath, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldTypesForAggregation$str() {
        return "HSEARCH600097: Multiple conflicting types to build an aggregation for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldTypesForAggregation(final String absoluteFieldPath, final LuceneFieldAggregationBuilderFactory component1, final LuceneFieldAggregationBuilderFactory component2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldTypesForAggregation$str(), absoluteFieldPath, component1, component2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotMixLuceneSearchQueryWithOtherAggregations$str() {
        return "HSEARCH600098: An Lucene query cannot include search aggregations built using a non-Lucene search scope. Given aggregation was: '%1$s'";
    }
    @Override
    public final SearchException cannotMixLuceneSearchQueryWithOtherAggregations(final SearchAggregation<?> aggregation) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMixLuceneSearchQueryWithOtherAggregations$str(), aggregation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH600099: The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }
    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(final SearchAggregation<?> aggregation, final Set<String> aggregationIndexes, final Set<String> scopeIndexes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String termsAggregationsNotSupportedByAnalyzedTextFieldType$str() {
        return "HSEARCH600100: Terms aggregations are not supported by this field's type (string field with analyzed). Use a normalized field instead.";
    }
    @Override
    public final SearchException termsAggregationsNotSupportedByAnalyzedTextFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), termsAggregationsNotSupportedByAnalyzedTextFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rangeAggregationsNotSupportedByFieldType$str() {
        return "HSEARCH600101: Range aggregations are not supported by this field's type.";
    }
    @Override
    public final SearchException rangeAggregationsNotSupportedByFieldType(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangeAggregationsNotSupportedByFieldType$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateAggregationKey$str() {
        return "HSEARCH600102: Multiple aggregations with the same key: '%1$s'";
    }
    @Override
    public final SearchException duplicateAggregationKey(final AggregationKey key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), duplicateAggregationKey$str(), new org.hibernate.search.engine.logging.spi.AggregationKeyFormatter(key)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedDSLAggregationsForNativeField$str() {
        return "HSEARCH600103: This field does not support aggregations.";
    }
    @Override
    public final SearchException unsupportedDSLAggregationsForNativeField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unsupportedDSLAggregationsForNativeField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH600104: Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.";
    }
    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(final String searchAnalyzer, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingObjectFieldModel$str() {
        return "HSEARCH600105: Multiple conflicting models for object field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingObjectFieldModel(final String absoluteFieldPath, final LuceneIndexSchemaObjectFieldNode index1Model, final LuceneIndexSchemaObjectFieldNode index2Model, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingObjectFieldModel$str(), absoluteFieldPath, index1Model, index2Model), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingFieldModel$str() {
        return "HSEARCH600106: Multiple conflicting models for field '%1$s': '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingFieldModel(final String absoluteFieldPath, final LuceneIndexSchemaObjectFieldNode objectNode, final LuceneIndexSchemaFieldNode fieldNode, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingFieldModel$str(), absoluteFieldPath, objectNode, fieldNode), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timedOut$str() {
        return "HSEARCH600107: Search query exceeded the timeout of %1$s: '%2$s'.";
    }
    @Override
    public final SearchTimeoutException timedOut(final Duration timeout, final String queryDescription) {
        final SearchTimeoutException result = new SearchTimeoutException(String.format(getLoggingLocale(), timedOut$str(), new org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter(timeout), queryDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIOStrategyName$str() {
        return "HSEARCH600108: Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidIOStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIOStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingIndex$str() {
        return "HSEARCH600109: Index does not exist for directory '%1$s'";
    }
    @Override
    public final SearchException missingIndex(final Directory directory, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingIndex$str(), directory), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToValidateIndexDirectory$str() {
        return "HSEARCH600110: Unable to validate index directory: %1$s";
    }
    @Override
    public final SearchException unableToValidateIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToValidateIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDropIndexDirectory$str() {
        return "HSEARCH600111: Unable to drop index directory: %1$s";
    }
    @Override
    public final SearchException unableToDropIndexDirectory(final String causeMessage, final EventContext context, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToDropIndexDirectory$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conflictingNestedDocumentPathHierarchy$str() {
        return "HSEARCH600112: Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.";
    }
    @Override
    public final SearchException conflictingNestedDocumentPathHierarchy(final String absoluteFieldPath, final List<String> nestedDocumentPathHierarchy1, final List<String> nestedDocumentPathHierarchy2, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), conflictingNestedDocumentPathHierarchy$str(), absoluteFieldPath, nestedDocumentPathHierarchy1, nestedDocumentPathHierarchy2), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String simpleQueryStringSpanningMultipleNestedPaths$str() {
        return "HSEARCH600113: Simple query string targets fields [%1$s, %3$s] spanning multiple nested paths: %2$s, %4$s.";
    }
    @Override
    public final SearchException simpleQueryStringSpanningMultipleNestedPaths(final String fieldPath1, final String nestedPath1, final String fieldPath2, final String nestedPath2) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), simpleQueryStringSpanningMultipleNestedPaths$str(), fieldPath1, nestedPath1, fieldPath2, nestedPath2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeMedianAcrossNested$str() {
        return "HSEARCH600114: Cannot compute the median across nested documents.";
    }
    @Override
    public final SearchException cannotComputeMedianAcrossNested(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeMedianAcrossNested$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeSumOrAvgOrMedianForStringField$str() {
        return "HSEARCH600115: Cannot compute the sum, average or median of a text field. Only min and max are supported.";
    }
    @Override
    public final SearchException cannotComputeSumOrAvgOrMedianForStringField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeSumOrAvgOrMedianForStringField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeSumForTemporalField$str() {
        return "HSEARCH600116: Cannot compute the sum of a temporal field. Only min, max, avg and median are supported.";
    }
    @Override
    public final SearchException cannotComputeSumForTemporalField(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeSumForTemporalField$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotComputeSumForDistanceSort$str() {
        return "HSEARCH600117: Cannot compute the sum for a distance sort. Only min, max, avg and median are supported.";
    }
    @Override
    public final SearchException cannotComputeSumForDistanceSort(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotComputeSumForDistanceSort$str()), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String uncommittedOperationsBecauseOfFailure$str() {
        return "HSEARCH600118: A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s";
    }
    @Override
    public final SearchException uncommittedOperationsBecauseOfFailure(final String causeMessage, final EventContext context, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), uncommittedOperationsBecauseOfFailure$str(), causeMessage), cause, context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterSortOnRootDocumentField$str() {
        return "HSEARCH600120: Field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterSortOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterSortOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNestedObjectPathForPredicate$str() {
        return "HSEARCH600121: Predicate targets unexpected fields %2$s. Only fields that are contained in the nested object with path '%1$s' are allowed here.";
    }
    @Override
    public final SearchException invalidNestedObjectPathForPredicate(final String nestedObjectPath, final List<String> fieldPaths) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNestedObjectPathForPredicate$str(), nestedObjectPath, fieldPaths));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFilterAggregationOnRootDocumentField$str() {
        return "HSEARCH600122: Field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.";
    }
    @Override
    public final SearchException cannotFilterAggregationOnRootDocumentField(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotFilterAggregationOnRootDocumentField$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalIndexWriterSetting$str() {
        return "HSEARCH600123: IndexWriter setting '%1$s' cannot be set to '%2$s': %3$s";
    }
    @Override
    public final SearchException illegalIndexWriterSetting(final String settingName, final Object settingValue, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalIndexWriterSetting$str(), settingName, settingValue, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalMergePolicySetting$str() {
        return "HSEARCH600124: Merge policy setting '%1$s' cannot be set to '%2$s': %3$s";
    }
    @Override
    public final SearchException illegalMergePolicySetting(final String settingName, final Object settingValue, final String message, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), illegalMergePolicySetting$str(), settingName, settingValue, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexSchemaFieldTemplateNameConflict$str() {
        return "HSEARCH600125: The index field template '%1$s' was added twice. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }
    @Override
    public final SearchException indexSchemaFieldTemplateNameConflict(final String name, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexSchemaFieldTemplateNameConflict$str(), name), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFieldValueType$str() {
        return "HSEARCH600126: Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.";
    }
    @Override
    public final SearchException invalidFieldValueType(final Class<?> fieldValueType, final Class<?> invalidValueType, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFieldValueType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(fieldValueType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(invalidValueType)), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownFieldForIndexing$str() {
        return "HSEARCH600127: Unknown field '%1$s'.";
    }
    @Override
    public final SearchException unknownFieldForIndexing(final String absoluteFieldPath, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownFieldForIndexing$str(), absoluteFieldPath), context);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexElementTypeRootIsNotObjectField$str() {
        return "HSEARCH600128: Invalid type: the index root is not an object field.";
    }
    @Override
    public final SearchException invalidIndexElementTypeRootIsNotObjectField() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexElementTypeRootIsNotObjectField$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexElementTypeValueFieldIsNotObjectField$str() {
        return "HSEARCH600129: Invalid type: '%1$s' is a value field, not an object field.";
    }
    @Override
    public final SearchException invalidIndexElementTypeValueFieldIsNotObjectField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexElementTypeValueFieldIsNotObjectField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexElementTypeObjectFieldIsNotValueField$str() {
        return "HSEARCH600130: Invalid type: '%1$s' is an object field, not a value field.";
    }
    @Override
    public final SearchException invalidIndexElementTypeObjectFieldIsNotValueField(final String absolutePath) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIndexElementTypeObjectFieldIsNotValueField$str(), absolutePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
