/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.Optional;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.cfg.LuceneIndexSettings;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.IOStrategyName;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.DebugIOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessorImpl;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.NearRealTimeIOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterConfigSource;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneBatchedWorkProcessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.backend.lucene.schema.management.impl.LuceneIndexSchemaManager;
import org.hibernate.search.backend.lucene.schema.management.impl.SchemaManagementIndexManagerContext;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexIndexer;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexIndexingPlan;
import org.hibernate.search.backend.lucene.work.execution.impl.LuceneIndexWorkspace;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionBackendContext;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexManagerBackendContext
implements WorkExecutionBackendContext,
SearchBackendContext {
    private static final ConfigurationProperty<IOStrategyName> IO_STRATEGY = ConfigurationProperty.forKey((String)"io.strategy").as(IOStrategyName.class, IOStrategyName::of).withDefault((Object)LuceneIndexSettings.Defaults.IO_STRATEGY).build();
    private final LuceneBackend backendAPI;
    private final EventContext eventContext;
    private final BackendThreads threads;
    private final DirectoryProvider directoryProvider;
    private final Similarity similarity;
    private final LuceneWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final FailureHandler failureHandler;
    private final LuceneSyncWorkOrchestrator readOrchestrator;

    public IndexManagerBackendContext(LuceneBackend backendAPI, EventContext eventContext, BackendThreads threads, DirectoryProvider directoryProvider, Similarity similarity, LuceneWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, TimingSource timingSource, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, FailureHandler failureHandler, LuceneSyncWorkOrchestrator readOrchestrator) {
        this.backendAPI = backendAPI;
        this.eventContext = eventContext;
        this.threads = threads;
        this.directoryProvider = directoryProvider;
        this.similarity = similarity;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.workFactory = workFactory;
        this.failureHandler = failureHandler;
        this.readOrchestrator = readOrchestrator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    @Override
    public <R> IndexIndexingPlan<R> createIndexingPlan(WorkExecutionIndexManagerContext indexManagerContext, LuceneIndexEntryFactory indexEntryFactory, BackendSessionContext sessionContext, EntityReferenceFactory<R> entityReferenceFactory, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexIndexingPlan<R>(this.workFactory, indexManagerContext, indexEntryFactory, sessionContext, entityReferenceFactory, commitStrategy, refreshStrategy);
    }

    @Override
    public IndexIndexer createIndexer(WorkExecutionIndexManagerContext indexManagerContext, LuceneIndexEntryFactory indexEntryFactory, BackendSessionContext sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexIndexer(this.workFactory, indexEntryFactory, indexManagerContext, sessionContext);
    }

    @Override
    public IndexWorkspace createWorkspace(WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneIndexWorkspace(this.workFactory, indexManagerContext, sessionContext);
    }

    @Override
    public LuceneSearchContext createSearchContext(BackendMappingContext mappingContext, LuceneScopeModel scopeModel) {
        return new LuceneSearchContext(mappingContext, this.analysisDefinitionRegistry, this.multiTenancyStrategy, this.timingSource, scopeModel);
    }

    @Override
    public <H> LuceneSearchQueryBuilder<H> createSearchQueryBuilder(LuceneSearchContext searchContext, BackendSessionContext sessionContext, LoadingContextBuilder<?, ?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new LuceneSearchQueryBuilder<H>(this.workFactory, this.readOrchestrator, searchContext, sessionContext, loadingContextBuilder, rootProjection);
    }

    LuceneBackend toAPI() {
        return this.backendAPI;
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    LuceneIndexEntryFactory createLuceneIndexEntryFactory(LuceneIndexModel model) {
        return new LuceneIndexEntryFactory(model, this.multiTenancyStrategy);
    }

    IOStrategy createIOStrategy(ConfigurationPropertySource propertySource) {
        switch ((IOStrategyName)((Object)IO_STRATEGY.get(propertySource))) {
            case DEBUG: {
                return DebugIOStrategy.create(this.directoryProvider, this.threads, this.failureHandler);
            }
        }
        return NearRealTimeIOStrategy.create(propertySource, this.directoryProvider, this.timingSource, this.threads, this.failureHandler);
    }

    LuceneIndexSchemaManager createSchemaManager(SchemaManagementIndexManagerContext context) {
        return new LuceneIndexSchemaManager(this.workFactory, context);
    }

    Shard createShard(IOStrategy ioStrategy, LuceneIndexModel model, Optional<String> shardId, ConfigurationPropertySource propertySource) {
        IndexAccessorImpl indexAccessor = null;
        String indexName = model.hibernateSearchName();
        EventContext shardEventContext = EventContexts.fromIndexNameAndShardId((String)model.hibernateSearchName(), shardId);
        IndexWriterConfigSource writerConfigSource = IndexWriterConfigSource.create(this.similarity, model.getIndexingAnalyzer(), propertySource, shardEventContext);
        try {
            indexAccessor = ioStrategy.createIndexAccessor(indexName, shardEventContext, shardId, writerConfigSource);
            LuceneParallelWorkOrchestratorImpl managementOrchestrator = this.createIndexManagementOrchestrator(shardEventContext, indexAccessor);
            LuceneSerialWorkOrchestratorImpl indexingOrchestrator = this.createIndexingOrchestrator(shardEventContext, indexAccessor);
            Shard shard = new Shard(shardEventContext, indexAccessor, managementOrchestrator, indexingOrchestrator);
            return shard;
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)indexAccessor);
            throw e;
        }
    }

    private LuceneParallelWorkOrchestratorImpl createIndexManagementOrchestrator(EventContext eventContext, IndexAccessorImpl indexAccessor) {
        return new LuceneParallelWorkOrchestratorImpl("Lucene index management orchestrator for " + eventContext.render(), eventContext, indexAccessor, this.threads);
    }

    private LuceneSerialWorkOrchestratorImpl createIndexingOrchestrator(EventContext eventContext, IndexAccessorImpl indexAccessor) {
        return new LuceneSerialWorkOrchestratorImpl("Lucene indexing orchestrator for " + eventContext.render(), new LuceneBatchedWorkProcessor(eventContext, indexAccessor), this.threads, this.failureHandler);
    }
}

