/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.impl.ShardingStrategyInitializationContextImpl;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.schema.management.impl.SchemaManagementIndexManagerContext;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;

class ShardHolder
implements ReadIndexManagerContext,
WorkExecutionIndexManagerContext,
SchemaManagementIndexManagerContext {
    private final IndexManagerBackendContext backendContext;
    private final LuceneIndexModel model;
    private BeanHolder<? extends ShardingStrategy> shardingStrategyHolder;
    private final Map<String, Shard> shards = new LinkedHashMap<String, Shard>();
    private final List<LuceneParallelWorkOrchestrator> managementOrchestrators = new ArrayList<LuceneParallelWorkOrchestrator>();

    ShardHolder(IndexManagerBackendContext backendContext, LuceneIndexModel model) {
        this.backendContext = backendContext;
        this.model = model;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[indexName=" + this.model.hibernateSearchName() + "]";
    }

    void start(IndexManagerStartContext startContext) {
        ConfigurationPropertySource propertySource = startContext.getConfigurationPropertySource();
        try {
            IOStrategy ioStrategy = this.backendContext.createIOStrategy(propertySource);
            ShardingStrategyInitializationContextImpl initializationContext = new ShardingStrategyInitializationContextImpl(this.backendContext, ioStrategy, this.model, startContext, propertySource);
            this.shardingStrategyHolder = initializationContext.create(this.shards);
            if (startContext.getFailureCollector().hasFailure()) {
                return;
            }
            for (Shard shard : this.shards.values()) {
                shard.start(propertySource);
                this.managementOrchestrators.add(shard.getManagementOrchestrator());
            }
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(Shard::stop, this.shards.values());
            this.shards.clear();
            this.managementOrchestrators.clear();
            throw e;
        }
    }

    CompletableFuture<?> preStop() {
        CompletableFuture[] futures = new CompletableFuture[this.shards.size()];
        int i = 0;
        for (Shard shard : this.shards.values()) {
            futures[i] = shard.preStop();
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }

    void stop() throws IOException {
        try (Closer closer = new Closer();){
            closer.pushAll(Shard::stop, this.shards.values());
            this.shards.clear();
            this.managementOrchestrators.clear();
        }
    }

    @Override
    public void openIndexReaders(Set<String> routingKeys, DirectoryReaderCollector readerCollector) throws IOException {
        String mappedTypeName = this.model.getMappedTypeName();
        Collection<Shard> enabledShards = this.toShards(routingKeys);
        for (Shard shard : enabledShards) {
            readerCollector.collect(mappedTypeName, shard.openReader());
        }
    }

    @Override
    public String getIndexName() {
        return this.model.hibernateSearchName();
    }

    @Override
    public String getMappedTypeName() {
        return this.model.getMappedTypeName();
    }

    @Override
    public LuceneSerialWorkOrchestrator getIndexingOrchestrator(String documentId, String routingKey) {
        return this.toShard(documentId, routingKey).getIndexingOrchestrator();
    }

    @Override
    public List<LuceneParallelWorkOrchestrator> getManagementOrchestrators(Set<String> routingKeys) {
        Collection<Shard> enabledShards = this.toShards(routingKeys);
        ArrayList<LuceneParallelWorkOrchestrator> orchestrators = new ArrayList<LuceneParallelWorkOrchestrator>();
        for (Shard shard : enabledShards) {
            orchestrators.add(shard.getManagementOrchestrator());
        }
        return orchestrators;
    }

    @Override
    public List<LuceneParallelWorkOrchestrator> getAllManagementOrchestrators() {
        return this.managementOrchestrators;
    }

    public List<Shard> getShardsForTests() {
        return new ArrayList<Shard>(this.shards.values());
    }

    private Collection<Shard> toShards(Set<String> routingKeys) {
        if (this.shardingStrategyHolder == null || routingKeys.isEmpty()) {
            return this.shards.values();
        }
        Set<String> shardIdentifiers = ((ShardingStrategy)this.shardingStrategyHolder.get()).toShardIdentifiers(routingKeys);
        HashSet<Shard> enabledShards = new HashSet<Shard>();
        for (String shardId : shardIdentifiers) {
            enabledShards.add(this.shards.get(shardId));
        }
        return enabledShards;
    }

    private Shard toShard(String documentId, String routingKey) {
        if (this.shardingStrategyHolder == null) {
            return this.shards.values().iterator().next();
        }
        String shardId = ((ShardingStrategy)this.shardingStrategyHolder.get()).toShardIdentifier(documentId, routingKey);
        return this.shards.get(shardId);
    }
}

