/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.search.timeout.impl.TimeoutManager;

public class TimeoutCountCollector
extends SimpleCollector {
    private final TimeoutManager timeoutManager;
    private int totalHits;

    public TimeoutCountCollector(TimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public void collect(int doc) {
        if (this.totalHits % 256 == 0) {
            this.timeoutManager.checkTimedOut();
        }
        ++this.totalHits;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

