/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.SloppyMath;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.SortedNumericDoubleDocValues;
import org.hibernate.search.engine.spatial.GeoPoint;

public class GeoPointDistanceDocValues
extends SortedNumericDoubleDocValues {
    private final SortedNumericDocValues values;
    private final double latitude;
    private final double longitude;
    private double[] distances = new double[1];
    private int distanceIndex;

    public GeoPointDistanceDocValues(SortedNumericDocValues values, GeoPoint center) {
        this.values = values;
        this.latitude = center.getLatitude();
        this.longitude = center.getLongitude();
    }

    @Override
    public double nextValue() throws IOException {
        this.setDistancesIfNecessary();
        return this.distances[this.distanceIndex++];
    }

    @Override
    public int docValueCount() {
        return this.values.docValueCount();
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        this.distanceIndex = -1;
        return this.values.advanceExact(doc);
    }

    public int docID() {
        return this.values.docID();
    }

    public int nextDoc() throws IOException {
        this.distanceIndex = -1;
        return this.values.nextDoc();
    }

    public int advance(int target) throws IOException {
        this.distanceIndex = -1;
        return this.values.advance(target);
    }

    public long cost() {
        return this.values.cost();
    }

    private void setDistancesIfNecessary() throws IOException {
        if (this.distanceIndex >= 0) {
            return;
        }
        int count = this.values.docValueCount();
        if (this.distances.length < count) {
            this.distances = new double[count];
        }
        for (int i = 0; i < count; ++i) {
            long encodedPoint = this.values.nextValue();
            double pointLatitude = GeoEncodingUtils.decodeLatitude((int)((int)(encodedPoint >>> 32)));
            double pointLongitude = GeoEncodingUtils.decodeLongitude((int)((int)encodedPoint));
            this.distances[i] = SloppyMath.haversinMeters((double)this.latitude, (double)this.longitude, (double)pointLatitude, (double)pointLongitude);
        }
        Arrays.sort(this.distances, 0, count);
        this.distanceIndex = 0;
    }
}

