/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneBatchedWork;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneBatchedWorkProcessor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWorkProcessor;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.data.impl.SimpleHashFunction;
import org.hibernate.search.util.common.impl.Closer;

public class LuceneSerialWorkOrchestratorImpl
extends AbstractWorkOrchestrator<LuceneBatchedWork<?>>
implements LuceneSerialWorkOrchestrator {
    private static final ConfigurationProperty<Integer> QUEUE_COUNT = ConfigurationProperty.forKey((String)"indexing.queue_count").asInteger().withDefault((Object)10).build();
    private static final ConfigurationProperty<Integer> QUEUE_SIZE = ConfigurationProperty.forKey((String)"indexing.queue_size").asInteger().withDefault((Object)1000).build();
    private final LuceneBatchedWorkProcessor processor;
    private final BackendThreads threads;
    private final FailureHandler failureHandler;
    private BatchingExecutor<LuceneBatchedWorkProcessor>[] executors;

    public LuceneSerialWorkOrchestratorImpl(String name, LuceneBatchedWorkProcessor processor, BackendThreads threads, FailureHandler failureHandler) {
        super(name);
        this.processor = processor;
        this.threads = threads;
        this.failureHandler = failureHandler;
    }

    @Override
    public void forceCommitInCurrentThread() {
        this.processor.forceCommit();
    }

    @Override
    public void forceRefreshInCurrentThread() {
        this.processor.forceRefresh();
    }

    protected void doStart(ConfigurationPropertySource propertySource) {
        int queueCount = (Integer)QUEUE_COUNT.get(propertySource);
        int queueSize = (Integer)QUEUE_SIZE.get(propertySource);
        this.executors = new BatchingExecutor[queueCount];
        for (int i = 0; i < this.executors.length; ++i) {
            this.executors[i] = new BatchingExecutor(this.getName() + " - " + i, (BatchedWorkProcessor)this.processor, queueSize, true, this.failureHandler);
        }
        for (BatchingExecutor<LuceneBatchedWorkProcessor> executor : this.executors) {
            executor.start((ExecutorService)this.threads.getWriteExecutor());
        }
    }

    protected void doSubmit(LuceneBatchedWork<?> work) throws InterruptedException {
        ((BatchingExecutor)SimpleHashFunction.pick((Object[])this.executors, (String)work.getQueuingKey())).submit(work);
    }

    protected CompletableFuture<?> getCompletion() {
        CompletableFuture[] completions = new CompletableFuture[this.executors.length];
        for (int i = 0; i < this.executors.length; ++i) {
            completions[i] = this.executors[i].getCompletion();
        }
        return CompletableFuture.allOf(completions);
    }

    protected void doStop() {
        try (Closer closer = new Closer();){
            closer.pushAll(BatchingExecutor::stop, (Object[])this.executors);
        }
    }
}

