/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFieldAggregationBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;

abstract class AbstractLuceneStandardFieldAggregationBuilderFactory<F>
extends AbstractLuceneFieldAggregationBuilderFactory<F> {
    private final DslConverter<? super F, ? extends F> rawToFieldValueConverter;
    private final ProjectionConverter<? super F, F> rawFromFieldValueConverter;

    AbstractLuceneStandardFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends F> toFieldValueConverter, DslConverter<? super F, ? extends F> rawToFieldValueConverter, ProjectionConverter<? super F, ?> fromFieldValueConverter, ProjectionConverter<? super F, F> rawFromFieldValueConverter) {
        super(aggregable, toFieldValueConverter, fromFieldValueConverter);
        this.rawToFieldValueConverter = rawToFieldValueConverter;
        this.rawFromFieldValueConverter = rawFromFieldValueConverter;
    }

    protected <T> DslConverter<?, ? extends F> getToFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        DslConverter result;
        switch (convert) {
            case NO: {
                result = this.rawToFieldValueConverter;
                break;
            }
            default: {
                result = this.toFieldValueConverter;
            }
        }
        if (!result.isValidInputType(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }

    protected <T> ProjectionConverter<? super F, ? extends T> getFromFieldValueConverter(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        ProjectionConverter result;
        switch (convert) {
            case NO: {
                result = this.rawFromFieldValueConverter;
                break;
            }
            default: {
                result = this.fromFieldValueConverter;
            }
        }
        if (!result.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidAggregationInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return result;
    }
}

