/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneIntegerDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneIntegerFieldCodec
extends AbstractLuceneNumericFieldCodec<Integer, Integer> {
    public LuceneIntegerFieldCodec(boolean projectable, boolean searchable, boolean sortable, boolean aggregable, Integer indexNullAsValue) {
        super(projectable, searchable, sortable, aggregable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, Integer value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.intValue()));
    }

    @Override
    public Integer decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        return (Integer)field.numericValue();
    }

    @Override
    public Integer encode(Integer value) {
        return value;
    }

    @Override
    public Integer decode(Integer encoded) {
        return encoded;
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneIntegerDomain.get();
    }
}

