/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.predicate.parse.impl.LuceneWildcardExpressionHelper;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

class LuceneTextWildcardPredicateBuilder
extends AbstractLuceneSingleFieldPredicateBuilder
implements WildcardPredicateBuilder<LuceneSearchPredicateBuilder> {
    private final Analyzer analyzerOrNormalizer;
    private String pattern;

    LuceneTextWildcardPredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy, Analyzer analyzerOrNormalizer) {
        super(absoluteFieldPath, nestedPathHierarchy);
        this.analyzerOrNormalizer = analyzerOrNormalizer;
    }

    public void pattern(String wildcardPattern) {
        this.pattern = wildcardPattern;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        BytesRef analyzedWildcard = LuceneWildcardExpressionHelper.analyzeWildcard(this.analyzerOrNormalizer, this.absoluteFieldPath, this.pattern);
        return new WildcardQuery(new Term(this.absoluteFieldPath, analyzedWildcard));
    }
}

