/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneFieldSortBuilderFactory<F, C extends LuceneFieldCodec<F>>
implements LuceneFieldSortBuilderFactory {
    protected static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final boolean sortable;
    protected final C codec;

    public AbstractLuceneFieldSortBuilderFactory(boolean sortable, C codec) {
        this.sortable = sortable;
        this.codec = codec;
    }

    @Override
    public boolean hasCompatibleCodec(LuceneFieldSortBuilderFactory other) {
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        AbstractLuceneFieldSortBuilderFactory otherFactory = (AbstractLuceneFieldSortBuilderFactory)other;
        return this.sortable == otherFactory.sortable && this.codec.isCompatibleWith((LuceneFieldCodec<?>)otherFactory.codec);
    }

    protected void checkSortable(String absoluteFieldPath) {
        if (!this.sortable) {
            throw log.unsortableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

