/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneGeoPointFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneFieldSortBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneGeoPointDistanceSortBuilder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneGeoPointFieldSortBuilderFactory
extends AbstractLuceneFieldSortBuilderFactory<GeoPoint, LuceneGeoPointFieldCodec> {
    public LuceneGeoPointFieldSortBuilderFactory(boolean sortable, LuceneGeoPointFieldCodec codec) {
        super(sortable, codec);
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public FieldSortBuilder<LuceneSearchSortBuilder> createFieldSortBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, String nestedDocumentPath, LuceneCompatibilityChecker converterChecker) {
        throw log.traditionalSortNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public DistanceSortBuilder<LuceneSearchSortBuilder> createDistanceSortBuilder(String absoluteFieldPath, String nestedDocumentPath, GeoPoint center) {
        this.checkSortable(absoluteFieldPath);
        return new LuceneGeoPointDistanceSortBuilder(absoluteFieldPath, nestedDocumentPath, center);
    }

    @Override
    public boolean hasCompatibleConverter(LuceneFieldSortBuilderFactory other) {
        return true;
    }
}

