/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.cfg;

import org.hibernate.search.backend.lucene.lowlevel.index.IOStrategyName;

public final class LuceneIndexSettings {
    public static final String IO_PREFIX = "io.";
    public static final String IO_STRATEGY = "io.strategy";
    public static final String IO_COMMIT_INTERVAL = "io.commit_interval";
    public static final String IO_REFRESH_INTERVAL = "io.refresh_interval";
    public static final String IO_WRITER_PREFIX = "io.writer.";
    public static final String IO_WRITER_MAX_BUFFERED_DOCS = "io.writer.max_buffered_docs";
    public static final String IO_WRITER_RAM_BUFFER_SIZE = "io.writer.ram_buffer_size";
    public static final String IO_WRITER_INFOSTREAM = "io.writer.infostream";
    public static final String IO_MERGE_PREFIX = "io.merge.";
    public static final String IO_MERGE_MAX_DOCS = "io.merge.max_docs";
    public static final String IO_MERGE_FACTOR = "io.merge.factor";
    public static final String IO_MERGE_MIN_SIZE = "io.merge.min_size";
    public static final String IO_MERGE_MAX_SIZE = "io.merge.max_size";
    public static final String IO_MERGE_MAX_FORCED_SIZE = "io.merge.max_forced_size";
    public static final String IO_MERGE_CALIBRATE_BY_DELETES = "io.merge.calibrate_by_deletes";
    public static final String SHARDING_PREFIX = "sharding.";
    public static final String SHARDING_STRATEGY = "sharding.strategy";
    public static final String SHARDING_NUMBER_OF_SHARDS = "sharding.number_of_shards";
    public static final String SHARDING_SHARD_IDENTIFIERS = "sharding.shard_identifiers";
    public static final String INDEXING_PREFIX = "indexing.";
    public static final String INDEXING_QUEUE_COUNT = "indexing.queue_count";
    public static final String INDEXING_QUEUE_SIZE = "indexing.queue_size";

    private LuceneIndexSettings() {
    }

    public static final class Defaults {
        public static final String SHARDING_STRATEGY = "none";
        public static final IOStrategyName IO_STRATEGY = IOStrategyName.NEAR_REAL_TIME;
        public static final int IO_COMMIT_INTERVAL = 1000;
        public static final int IO_REFRESH_INTERVAL = 0;
        public static final int INDEXING_QUEUE_COUNT = 10;
        public static final int INDEXING_QUEUE_SIZE = 1000;

        private Defaults() {
        }
    }

    public static final class IndexingRadicals {
        public static final String QUEUE_COUNT = "queue_count";
        public static final String QUEUE_SIZE = "queue_size";

        private IndexingRadicals() {
        }
    }

    public static final class ShardingRadicals {
        public static final String STRATEGY = "strategy";
        public static final String NUMBER_OF_SHARDS = "number_of_shards";
        public static final String SHARD_IDENTIFIERS = "shard_identifiers";

        private ShardingRadicals() {
        }
    }

    public static final class MergeRadicals {
        public static final String MAX_DOCS = "max_docs";
        public static final String FACTOR = "factor";
        public static final String MIN_SIZE = "min_size";
        public static final String MAX_SIZE = "max_size";
        public static final String MAX_FORCED_SIZE = "max_forced_size";
        public static final String CALIBRATE_BY_DELETES = "calibrate_by_deletes";

        private MergeRadicals() {
        }
    }

    public static final class WriterRadicals {
        public static final String MAX_BUFFERED_DOCS = "max_buffered_docs";
        public static final String RAM_BUFFER_SIZE = "ram_buffer_size";
        public static final String INFOSTREAM = "infostream";

        private WriterRadicals() {
        }
    }

    public static final class IORadicals {
        public static final String STRATEGY = "strategy";
        public static final String COMMIT_INTERVAL = "commit_interval";
        public static final String REFRESH_INTERVAL = "refresh_interval";

        private IORadicals() {
        }
    }
}

