/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.util.common.pattern.spi.SimpleGlobPattern;

public abstract class AbstractLuceneIndexSchemaFieldTemplate<N> {
    private final IndexFieldInclusion inclusion;
    private final SimpleGlobPattern absolutePathGlob;
    private final boolean multiValued;

    AbstractLuceneIndexSchemaFieldTemplate(LuceneIndexSchemaObjectNode declaringParent, IndexFieldInclusion inclusion, SimpleGlobPattern absolutePathGlob, boolean multiValued) {
        this.inclusion = declaringParent.getInclusion().compose(inclusion);
        this.absolutePathGlob = absolutePathGlob;
        this.multiValued = multiValued;
    }

    public IndexFieldInclusion getInclusion() {
        return this.inclusion;
    }

    N createNodeIfMatching(LuceneIndexModel model, String absolutePath) {
        if (!this.absolutePathGlob.matches(absolutePath)) {
            return null;
        }
        FieldPaths.RelativizedPath relativizedPath = FieldPaths.relativize((String)absolutePath);
        LuceneIndexSchemaObjectNode parent = relativizedPath.parentPath.map(path -> model.getObjectFieldNode((String)path, IndexFieldFilter.ALL)).orElseGet(model::root);
        return this.createNode(parent, relativizedPath.relativePath, this.inclusion, this.multiValued);
    }

    protected abstract N createNode(LuceneIndexSchemaObjectNode var1, String var2, IndexFieldInclusion var3, boolean var4);
}

