/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldTemplate;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexModel
implements AutoCloseable,
IndexDescriptor {
    private final String indexName;
    private final String mappedTypeName;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final LuceneIndexSchemaObjectNode rootNode;
    private final Map<String, LuceneIndexSchemaObjectFieldNode> objectFieldNodes;
    private final Map<String, LuceneIndexSchemaFieldNode<?>> fieldNodes;
    private final List<IndexFieldDescriptor> staticFields;
    private final List<LuceneIndexSchemaObjectFieldTemplate> objectFieldTemplates;
    private final List<LuceneIndexSchemaFieldTemplate> fieldTemplates;
    private final ConcurrentMap<String, LuceneIndexSchemaObjectFieldNode> dynamicObjectFieldNodesCache = new ConcurrentHashMap<String, LuceneIndexSchemaObjectFieldNode>();
    private final ConcurrentMap<String, LuceneIndexSchemaFieldNode<?>> dynamicFieldNodesCache = new ConcurrentHashMap();
    private final IndexingScopedAnalyzer indexingAnalyzer;
    private final SearchScopedAnalyzer searchAnalyzer;

    public LuceneIndexModel(String indexName, String mappedTypeName, ToDocumentIdentifierValueConverter<?> idDslConverter, LuceneIndexSchemaObjectNode rootNode, Map<String, LuceneIndexSchemaObjectFieldNode> objectFieldNodes, Map<String, LuceneIndexSchemaFieldNode<?>> fieldNodes, List<LuceneIndexSchemaObjectFieldTemplate> objectFieldTemplates, List<LuceneIndexSchemaFieldTemplate> fieldTemplates) {
        this.indexName = indexName;
        this.mappedTypeName = mappedTypeName;
        this.idDslConverter = idDslConverter;
        this.rootNode = rootNode;
        this.objectFieldNodes = CollectionHelper.toImmutableMap(objectFieldNodes);
        this.fieldNodes = CollectionHelper.toImmutableMap(fieldNodes);
        ArrayList theStaticFields = new ArrayList();
        objectFieldNodes.values().stream().filter(field -> IndexFieldInclusion.INCLUDED.equals((Object)field.getInclusion())).forEach(theStaticFields::add);
        fieldNodes.values().stream().filter(field -> IndexFieldInclusion.INCLUDED.equals((Object)field.getInclusion())).forEach(theStaticFields::add);
        this.staticFields = CollectionHelper.toImmutableList(theStaticFields);
        this.indexingAnalyzer = new IndexingScopedAnalyzer();
        this.searchAnalyzer = new SearchScopedAnalyzer();
        this.objectFieldTemplates = objectFieldTemplates;
        this.fieldTemplates = fieldTemplates;
    }

    @Override
    public void close() {
        this.indexingAnalyzer.close();
    }

    public String hibernateSearchName() {
        return this.indexName;
    }

    public LuceneIndexSchemaObjectNode root() {
        return this.rootNode;
    }

    public Optional<IndexFieldDescriptor> field(String absolutePath) {
        AbstractLuceneIndexSchemaFieldNode fieldDescriptor = this.getFieldNode(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
        if (fieldDescriptor == null) {
            fieldDescriptor = this.getObjectFieldNode(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
        }
        return Optional.ofNullable(fieldDescriptor);
    }

    public Collection<IndexFieldDescriptor> staticFields() {
        return this.staticFields;
    }

    public String getMappedTypeName() {
        return this.mappedTypeName;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexName((String)this.indexName);
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        return this.idDslConverter;
    }

    public LuceneIndexSchemaObjectFieldNode getObjectFieldNode(String absolutePath, IndexFieldFilter filter) {
        LuceneIndexSchemaObjectFieldNode node = this.getNode(this.objectFieldNodes, this.objectFieldTemplates, this.dynamicObjectFieldNodesCache, absolutePath);
        return node == null ? null : (LuceneIndexSchemaObjectFieldNode)filter.filter((Object)node, node.getInclusion());
    }

    public LuceneIndexSchemaFieldNode<?> getFieldNode(String absolutePath, IndexFieldFilter filter) {
        LuceneIndexSchemaFieldNode<?> node = this.getNode(this.fieldNodes, this.fieldTemplates, this.dynamicFieldNodesCache, absolutePath);
        return node == null ? null : (LuceneIndexSchemaFieldNode)filter.filter(node, node.getInclusion());
    }

    public Analyzer getIndexingAnalyzer() {
        return this.indexingAnalyzer;
    }

    public Analyzer getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexName=" + this.indexName + "]";
    }

    private <N> N getNode(Map<String, N> staticNodes, List<? extends AbstractLuceneIndexSchemaFieldTemplate<N>> templates, ConcurrentMap<String, N> dynamicNodesCache, String absolutePath) {
        Object node = staticNodes.get(absolutePath);
        if (node != null) {
            return node;
        }
        node = dynamicNodesCache.get(absolutePath);
        if (node != null) {
            return node;
        }
        for (AbstractLuceneIndexSchemaFieldTemplate<N> template : templates) {
            node = template.createNodeIfMatching(this, absolutePath);
            if (node == null) continue;
            N previous = dynamicNodesCache.putIfAbsent(absolutePath, node);
            if (previous == null) break;
            node = previous;
            break;
        }
        return node;
    }

    private class SearchScopedAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected SearchScopedAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            LuceneIndexSchemaFieldNode<?> field = LuceneIndexModel.this.getFieldNode(fieldName, IndexFieldFilter.ALL);
            if (field == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            Analyzer analyzer = field.type().getSearchAnalyzerOrNormalizer();
            if (analyzer == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            return analyzer;
        }
    }

    private class IndexingScopedAnalyzer
    extends DelegatingAnalyzerWrapper {
        protected IndexingScopedAnalyzer() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            LuceneIndexSchemaFieldNode<?> field = LuceneIndexModel.this.getFieldNode(fieldName, IndexFieldFilter.ALL);
            if (field == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            Analyzer analyzer = field.type().getIndexingAnalyzerOrNormalizer();
            if (analyzer == null) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            return analyzer;
        }
    }
}

