/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBackendImpl
implements BackendImplementor,
LuceneBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final BackendThreads threads;
    private final BeanHolder<? extends DirectoryProvider> directoryProviderHolder;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final LuceneSyncWorkOrchestratorImpl readOrchestrator;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final EventContext eventContext;
    private final IndexManagerBackendContext indexManagerBackendContext;

    LuceneBackendImpl(String name, BackendThreads threads, BeanHolder<? extends DirectoryProvider> directoryProviderHolder, LuceneWorkFactory workFactory, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, TimingSource timingSource, FailureHandler failureHandler) {
        this.name = name;
        this.threads = threads;
        this.directoryProviderHolder = directoryProviderHolder;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        Similarity similarity = analysisDefinitionRegistry.getSimilarity();
        this.readOrchestrator = new LuceneSyncWorkOrchestratorImpl("Lucene read work orchestrator for backend " + name, similarity);
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexManagerBackendContext = new IndexManagerBackendContext(this, this.eventContext, threads, (DirectoryProvider)directoryProviderHolder.get(), similarity, workFactory, multiTenancyStrategy, timingSource, analysisDefinitionRegistry, failureHandler, this.readOrchestrator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + ", " + "directoryProvider=" + this.directoryProviderHolder.get() + "]";
    }

    public void start(BackendStartContext context) {
        this.threads.onStart(context.configurationPropertySource(), context.threadPoolProvider());
    }

    public CompletableFuture<?> preStop() {
        return CompletableFuture.completedFuture(null);
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.readOrchestrator);
            closer.push(holder -> ((DirectoryProvider)holder.get()).close(), this.directoryProviderHolder);
            closer.push(BeanHolder::close, this.directoryProviderHolder);
            closer.push(TimingSource::stop, (Object)this.timingSource);
            closer.push(BackendThreads::onStop, (Object)this.threads);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, LuceneBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    public Optional<Analyzer> analyzer(String name) {
        return Optional.ofNullable(this.analysisDefinitionRegistry.getAnalyzerDefinition(name));
    }

    public Optional<Analyzer> normalizer(String name) {
        return Optional.ofNullable(this.analysisDefinitionRegistry.getNormalizerDefinition(name));
    }

    public IndexManagerBuilder createIndexManagerBuilder(String indexName, String mappedTypeName, boolean multiTenancyEnabled, BackendBuildContext context, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(indexName, this.eventContext);
        }
        LuceneIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new LuceneIndexSchemaRootNodeBuilder(EventContexts.fromIndexName((String)indexName), mappedTypeName, this.analysisDefinitionRegistry);
        return new LuceneIndexManagerBuilder(this.indexManagerBackendContext, indexName, indexSchemaRootNodeBuilder);
    }
}

