/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.LockFactory;
import org.hibernate.search.backend.lucene.cfg.LuceneBackendSettings;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.FileSystemAccessStrategyName;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.FileSystemAccessStrategy;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.FileSystemUtils;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.LocalFileSystemDirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryCreationContext;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProviderInitializationContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LocalFileSystemDirectoryProvider
implements DirectoryProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "local-filesystem";
    private static final ConfigurationProperty<Path> ROOT = ConfigurationProperty.forKey((String)"root").as(Path.class, x$0 -> Paths.get(x$0, new String[0])).withDefault(() -> Paths.get(".", new String[0])).build();
    private static final ConfigurationProperty<FileSystemAccessStrategyName> FILESYSTEM_ACCESS_STRATEGY = ConfigurationProperty.forKey((String)"filesystem_access.strategy").as(FileSystemAccessStrategyName.class, FileSystemAccessStrategyName::of).withDefault((Object)LuceneBackendSettings.Defaults.DIRECTORY_FILESYSTEM_ACCESS_STRATEGY).build();
    private Path directoryRoot;
    private FileSystemAccessStrategy accessStrategy;
    private Supplier<LockFactory> lockFactorySupplier;

    public String toString() {
        return this.getClass().getSimpleName() + "[root=" + this.directoryRoot + "]";
    }

    @Override
    public void initialize(DirectoryProviderInitializationContext context) {
        ConfigurationPropertySource propertySource = context.configurationPropertySource();
        this.directoryRoot = ((Path)ROOT.get(propertySource)).toAbsolutePath();
        FileSystemAccessStrategyName accessStrategyName = (FileSystemAccessStrategyName)((Object)FILESYSTEM_ACCESS_STRATEGY.get(propertySource));
        this.accessStrategy = FileSystemAccessStrategy.get(accessStrategyName);
        this.lockFactorySupplier = context.createConfiguredLockFactorySupplier().orElseGet(() -> FSLockFactory::getDefault);
        try {
            FileSystemUtils.initializeWriteableDirectory(this.directoryRoot);
        }
        catch (Exception e) {
            throw log.unableToInitializeRootDirectory(this.directoryRoot, e.getMessage(), e);
        }
    }

    @Override
    public DirectoryHolder createDirectoryHolder(DirectoryCreationContext context) {
        Path directoryPath = this.directoryRoot.resolve(context.indexName());
        Optional<String> shardId = context.shardId();
        if (shardId.isPresent()) {
            directoryPath = directoryPath.resolve(shardId.get());
        }
        return new LocalFileSystemDirectoryHolder(directoryPath, this.accessStrategy, this.lockFactorySupplier, context.eventContext());
    }
}

