/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneSyncWorkOrchestratorImpl
extends AbstractWorkOrchestrator<WorkExecution<?>>
implements LuceneSyncWorkOrchestrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Similarity similarity;

    public LuceneSyncWorkOrchestratorImpl(String name, Similarity similarity) {
        super(name);
        this.similarity = similarity;
        this.start(null);
    }

    @Override
    public <T> T submit(Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys, ReadWork<T> work) {
        WorkExecution<T> workExecution = new WorkExecution<T>(this.similarity, indexNames, indexManagerContexts, routingKeys, work);
        Throwable throwable = null;
        try {
            this.submit(workExecution);
            T t = workExecution.getResult();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            if (throwable == null) {
                workExecution.close();
            } else {
                new SuppressingCloser(throwable).push(workExecution);
            }
        }
    }

    protected void doStart(ConfigurationPropertySource propertySource) {
    }

    protected void doSubmit(WorkExecution<?> work) {
        work.execute();
    }

    protected CompletableFuture<?> completion() {
        return CompletableFuture.completedFuture(null);
    }

    protected void doStop() {
    }

    static class WorkExecution<T>
    implements AutoCloseable,
    ReadWorkExecutionContext {
        private final Similarity similarity;
        private final Set<String> indexNames;
        private final HibernateSearchMultiReader indexReader;
        private final ReadWork<T> work;
        private T result;

        WorkExecution(Similarity similarity, Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys, ReadWork<T> work) {
            this.similarity = similarity;
            this.indexNames = indexNames;
            this.indexReader = HibernateSearchMultiReader.open(indexNames, indexManagerContexts, routingKeys);
            this.work = work;
        }

        @Override
        public IndexSearcher createSearcher() {
            IndexSearcher searcher = new IndexSearcher((IndexReader)this.indexReader);
            searcher.setSimilarity(this.similarity);
            return searcher;
        }

        @Override
        public IndexReaderMetadataResolver getIndexReaderMetadataResolver() {
            return this.indexReader.getMetadataResolver();
        }

        @Override
        public EventContext getEventContext() {
            return EventContexts.fromIndexNames(this.indexNames);
        }

        public void execute() {
            this.result = this.work.execute(this);
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void close() {
            try {
                this.indexReader.close();
            }
            catch (IOException | RuntimeException e) {
                log.unableToCloseIndexReader(this.getEventContext(), e);
            }
        }
    }
}

