/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.resources.impl;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.AssertionFailure;

public class BackendThreads {
    private static final OptionalConfigurationProperty<Integer> THREAD_POOL_SIZE = ConfigurationProperty.forKey((String)"thread_pool.size").asInteger().build();
    private final String prefix;
    private ThreadPoolProvider threadPoolProvider;
    private ScheduledExecutorService writeExecutor;

    public BackendThreads(String prefix) {
        this.prefix = prefix;
    }

    public void onStart(ConfigurationPropertySource propertySource, ThreadPoolProvider threadPoolProvider) {
        if (this.writeExecutor != null) {
            return;
        }
        this.threadPoolProvider = threadPoolProvider;
        int threadPoolSize = ((Optional)THREAD_POOL_SIZE.get(propertySource)).orElse(Runtime.getRuntime().availableProcessors());
        this.writeExecutor = threadPoolProvider.newScheduledExecutor(threadPoolSize, this.prefix + " - Worker thread");
    }

    public void onStop() {
        if (this.writeExecutor != null) {
            this.writeExecutor.shutdownNow();
        }
    }

    public ThreadProvider getThreadProvider() {
        this.checkStarted();
        return this.threadPoolProvider.threadProvider();
    }

    public ScheduledExecutorService getWriteExecutor() {
        this.checkStarted();
        return this.writeExecutor;
    }

    private void checkStarted() {
        if (this.writeExecutor == null) {
            throw new AssertionFailure("Attempt to retrieve the executor or related information before the backend was started. There is probably a bug in Hibernate Search, please report it.");
        }
    }
}

