/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.impl;

import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilderFactory;
import org.hibernate.search.backend.lucene.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;

public class LuceneIndexScope
implements IndexScope<LuceneSearchQueryElementCollector> {
    private final LuceneScopeModel model;
    private final LuceneSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final LuceneSearchSortBuilderFactoryImpl searchSortFactory;
    private final LuceneSearchQueryBuilderFactory searchQueryFactory;
    private final LuceneSearchProjectionBuilderFactory searchProjectionFactory;
    private final LuceneSearchAggregationBuilderFactory searchAggregationFactory;

    public LuceneIndexScope(SearchBackendContext backendContext, BackendMappingContext mappingContext, LuceneScopeModel model) {
        this.model = model;
        LuceneSearchContext searchContext = backendContext.createSearchContext(mappingContext, model);
        this.searchPredicateFactory = new LuceneSearchPredicateBuilderFactoryImpl(searchContext, model);
        this.searchSortFactory = new LuceneSearchSortBuilderFactoryImpl(searchContext, model);
        this.searchProjectionFactory = new LuceneSearchProjectionBuilderFactory(model);
        this.searchAggregationFactory = new LuceneSearchAggregationBuilderFactory(searchContext, model);
        this.searchQueryFactory = new LuceneSearchQueryBuilderFactory(backendContext, searchContext, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.model.getIndexNames() + "]";
    }

    public LuceneSearchPredicateBuilderFactoryImpl searchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public LuceneSearchSortBuilderFactoryImpl searchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public LuceneSearchQueryBuilderFactory searchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public LuceneSearchProjectionBuilderFactory searchProjectionFactory() {
        return this.searchProjectionFactory;
    }

    public SearchAggregationBuilderFactory<? super LuceneSearchQueryElementCollector> searchAggregationFactory() {
        return this.searchAggregationFactory;
    }
}

