/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNestedPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneNestablePredicateBuilder
extends AbstractLuceneSearchPredicateBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    AbstractLuceneNestablePredicateBuilder() {
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        if (expectedParentNestedPath != null && !nestedPathHierarchy.contains(expectedParentNestedPath)) {
            throw log.invalidNestedObjectPathForPredicate(expectedParentNestedPath, this.getFieldPathsForErrorMessage());
        }
    }

    @Override
    public final Query build(LuceneSearchPredicateContext context) {
        int hierarchyLastIndex;
        String path;
        String expectedNestedPath;
        this.checkNestableWithin(context.getNestedPath());
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        String string = expectedNestedPath = nestedPathHierarchy.isEmpty() ? null : nestedPathHierarchy.get(nestedPathHierarchy.size() - 1);
        if (Objects.equals(context.getNestedPath(), expectedNestedPath)) {
            return super.build(context);
        }
        LuceneSearchPredicateContext contextAfterImplicitNesting = new LuceneSearchPredicateContext(expectedNestedPath);
        Query result = super.build(contextAfterImplicitNesting);
        for (int i = hierarchyLastIndex = nestedPathHierarchy.size() - 1; i >= 0 && !(path = nestedPathHierarchy.get(i)).equals(context.getNestedPath()); --i) {
            String parentNestedDocumentPath = i == 0 ? null : nestedPathHierarchy.get(i - 1);
            result = LuceneNestedPredicateBuilder.doBuild(parentNestedDocumentPath, path, result);
        }
        return result;
    }

    protected abstract List<String> getNestedPathHierarchy();

    protected abstract List<String> getFieldPathsForErrorMessage();
}

