/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneStandardMatchPredicateBuilder<F, E, C extends LuceneStandardFieldCodec<F, E>>
extends AbstractLuceneSingleFieldPredicateBuilder
implements MatchPredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchContext searchContext;
    private final DslConverter<?, ? extends F> converter;
    private final DslConverter<F, ? extends F> rawConverter;
    private final LuceneCompatibilityChecker converterChecker;
    protected final C codec;
    protected E value;

    protected AbstractLuceneStandardMatchPredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, C codec) {
        super(absoluteFieldPath, nestedPathHierarchy);
        this.searchContext = searchContext;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
    }

    public void fuzzy(int maxEditDistance, int exactPrefixLength) {
        throw log.textPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void analyzer(String analyzerName) {
        throw log.textPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void skipAnalysis() {
        throw log.textPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void value(Object value, ValueConvert convert) {
        DslConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(convert);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.value = this.codec.encode((Object)converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    private DslConverter<?, ? extends F> getDslToIndexConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawConverter;
            }
        }
        this.converterChecker.failIfNotCompatible();
        return this.converter;
    }
}

