/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

class LuceneNestedPredicateBuilder
extends AbstractLuceneSingleFieldPredicateBuilder
implements NestedPredicateBuilder<LuceneSearchPredicateBuilder> {
    private LuceneSearchPredicateBuilder nestedBuilder;

    LuceneNestedPredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy) {
        super(absoluteFieldPath, nestedPathHierarchy.subList(0, nestedPathHierarchy.size() - 1));
    }

    public void nested(LuceneSearchPredicateBuilder nestedBuilder) {
        nestedBuilder.checkNestableWithin(this.absoluteFieldPath);
        this.nestedBuilder = nestedBuilder;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        LuceneSearchPredicateContext childContext = new LuceneSearchPredicateContext(this.absoluteFieldPath);
        return LuceneNestedPredicateBuilder.doBuild(context.getNestedPath(), this.absoluteFieldPath, this.nestedBuilder.build(childContext));
    }

    public static Query doBuild(String parentNestedDocumentPath, String nestedDocumentPath, Query nestedQuery) {
        if (nestedDocumentPath.equals(parentNestedDocumentPath)) {
            return nestedQuery;
        }
        BooleanQuery.Builder childQueryBuilder = new BooleanQuery.Builder();
        childQueryBuilder.add(Queries.childDocumentQuery(), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(Queries.nestedDocumentPathQuery(nestedDocumentPath), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(nestedQuery, BooleanClause.Occur.MUST);
        BitSetProducer parentFilter = Queries.parentFilter(parentNestedDocumentPath);
        return new ToParentBlockJoinQuery((Query)childQueryBuilder.build(), parentFilter, ScoreMode.Avg);
    }
}

