/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneDifferentNestedObjectCompatibilityChecker;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopedIndexFieldComponent;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneSucceedingCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneNestablePredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSimpleQueryStringPredicateBuilder
extends AbstractLuceneNestablePredicateBuilder
implements SimpleQueryStringPredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneScopeModel scopeModel;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final Map<String, LuceneSimpleQueryStringPredicateBuilderFieldState> fields = new LinkedHashMap<String, LuceneSimpleQueryStringPredicateBuilderFieldState>();
    private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;
    private String simpleQueryString;
    private Analyzer overrideAnalyzer;
    private boolean ignoreAnalyzer = false;
    private EnumSet<SimpleQueryFlag> flags;
    private LuceneCompatibilityChecker analyzerChecker = new LuceneSucceedingCompatibilityChecker();
    private LuceneDifferentNestedObjectCompatibilityChecker nestedCompatibilityChecker;

    LuceneSimpleQueryStringPredicateBuilder(LuceneSearchContext searchContext, LuceneScopeModel scopeModel) {
        this.scopeModel = scopeModel;
        this.analysisDefinitionRegistry = searchContext.getAnalysisDefinitionRegistry();
        this.nestedCompatibilityChecker = LuceneDifferentNestedObjectCompatibilityChecker.empty(scopeModel);
    }

    public void defaultOperator(BooleanOperator operator) {
        switch (operator) {
            case AND: {
                this.defaultOperator = BooleanClause.Occur.MUST;
                break;
            }
            case OR: {
                this.defaultOperator = BooleanClause.Occur.SHOULD;
            }
        }
    }

    public void flags(Set<SimpleQueryFlag> flags) {
        this.flags = EnumSet.copyOf(flags);
    }

    public SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
        LuceneSimpleQueryStringPredicateBuilderFieldState field = this.fields.get(absoluteFieldPath);
        if (field == null) {
            LuceneScopedIndexFieldComponent<LuceneFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, LuceneSearchPredicateBuilderFactoryImpl.PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
            field = fieldComponent.getComponent().createSimpleQueryStringFieldContext(absoluteFieldPath);
            this.analyzerChecker = this.analyzerChecker.combine(fieldComponent.getAnalyzerCompatibilityChecker());
            this.nestedCompatibilityChecker = this.nestedCompatibilityChecker.combineAndCheck(absoluteFieldPath);
            this.fields.put(absoluteFieldPath, field);
        }
        return field;
    }

    public void simpleQueryString(String simpleQueryString) {
        this.simpleQueryString = simpleQueryString;
    }

    public void analyzer(String analyzerName) {
        this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
        if (this.overrideAnalyzer == null) {
            throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexNames(this.scopeModel.getIndexNames()));
        }
    }

    public void skipAnalysis() {
        this.ignoreAnalyzer = true;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (!this.ignoreAnalyzer && this.overrideAnalyzer == null) {
            this.analyzerChecker.failIfNotCompatible();
        }
        Analyzer analyzer = this.buildAnalyzer();
        int flag = -1;
        if (this.flags != null) {
            flag = 0;
            for (SimpleQueryFlag operation : this.flags) {
                switch (operation) {
                    case AND: {
                        flag |= 1;
                        break;
                    }
                    case NOT: {
                        flag |= 2;
                        break;
                    }
                    case OR: {
                        flag |= 4;
                        break;
                    }
                    case PREFIX: {
                        flag |= 8;
                        break;
                    }
                    case PHRASE: {
                        flag |= 0x10;
                        break;
                    }
                    case PRECEDENCE: {
                        flag |= 0x20;
                        break;
                    }
                    case ESCAPE: {
                        flag |= 0x40;
                        break;
                    }
                    case WHITESPACE: {
                        flag |= 0x80;
                        break;
                    }
                    case FUZZY: {
                        flag |= 0x100;
                        break;
                    }
                    case NEAR: {
                        flag |= 0x200;
                    }
                }
            }
        }
        LinkedHashMap weights = new LinkedHashMap();
        for (Map.Entry entry : this.fields.entrySet()) {
            LuceneSimpleQueryStringPredicateBuilderFieldState state = (LuceneSimpleQueryStringPredicateBuilderFieldState)entry.getValue();
            Float boost = state.getBoost();
            if (boost == null) {
                boost = Float.valueOf(1.0f);
            }
            weights.put(entry.getKey(), boost);
        }
        SimpleQueryParser queryParser = new SimpleQueryParser(analyzer, weights, flag);
        queryParser.setDefaultOperator(this.defaultOperator);
        return queryParser.parse(this.simpleQueryString);
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedCompatibilityChecker.getNestedPathHierarchy();
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return new ArrayList<String>(this.fields.keySet());
    }

    private Analyzer buildAnalyzer() {
        if (this.ignoreAnalyzer) {
            return AnalyzerConstants.KEYWORD_ANALYZER;
        }
        if (this.overrideAnalyzer != null) {
            return this.overrideAnalyzer;
        }
        if (this.fields.size() == 1) {
            return this.fields.values().iterator().next().getAnalyzerOrNormalizer();
        }
        ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
        for (Map.Entry<String, LuceneSimpleQueryStringPredicateBuilderFieldState> entry : this.fields.entrySet()) {
            builder.setAnalyzer(entry.getKey(), entry.getValue().getAnalyzerOrNormalizer());
        }
        return builder.build();
    }
}

