/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.timeout.impl.TimeoutManager;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchQueryImpl<H>
extends AbstractSearchQuery<H, LuceneSearchResult<H>>
implements LuceneSearchQuery<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneWorkFactory workFactory;
    private final LuceneSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Set<String> routingKeys;
    private final Query luceneQuery;
    private final Sort luceneSort;
    private final LuceneSearcher<LuceneLoadableSearchResult<H>> searcher;
    private TimeoutManager timeoutManager;

    LuceneSearchQueryImpl(LuceneSyncWorkOrchestrator queryOrchestrator, LuceneWorkFactory workFactory, LuceneSearchContext searchContext, BackendSessionContext sessionContext, LoadingContext<?, ?> loadingContext, Set<String> routingKeys, TimeoutManager timeoutManager, Query luceneQuery, Sort luceneSort, LuceneSearcher<LuceneLoadableSearchResult<H>> searcher) {
        this.queryOrchestrator = queryOrchestrator;
        this.workFactory = workFactory;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.routingKeys = routingKeys;
        this.timeoutManager = timeoutManager;
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
        this.searcher = searcher;
    }

    public String queryString() {
        return this.luceneQuery.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[query=" + this.queryString() + ", sort=" + this.luceneSort + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public LuceneSearchResult<H> fetch(Integer offset, Integer limit) {
        this.timeoutManager.start();
        ReadWork<LuceneLoadableSearchResult<H>> work = this.workFactory.search(this.searcher, offset, limit);
        LuceneSearchResult<H> result = this.doSubmit(work).loadBlocking();
        this.timeoutManager.stop();
        return result;
    }

    public long fetchTotalHitCount() {
        this.timeoutManager.start();
        ReadWork<Integer> work = this.workFactory.count(this.searcher);
        Integer result = this.doSubmit(work);
        this.timeoutManager.stop();
        return result.intValue();
    }

    @Override
    public Explanation explain(String id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Set<String> targetedTypeNames = this.searchContext.getTypeNames();
        if (targetedTypeNames.size() != 1) {
            throw log.explainRequiresTypeName(targetedTypeNames);
        }
        return this.doExplain(targetedTypeNames.iterator().next(), id);
    }

    @Override
    public Explanation explain(String typeName, String id) {
        Contracts.assertNotNull((Object)typeName, (String)"typeName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Set<String> targetedIndexNames = this.searchContext.getTypeNames();
        if (!targetedIndexNames.contains(typeName)) {
            throw log.explainRequiresTypeTargetedByQuery(targetedIndexNames, typeName);
        }
        return this.doExplain(typeName, id);
    }

    @Override
    public Sort luceneSort() {
        return this.luceneSort;
    }

    private <T> T doSubmit(ReadWork<T> work) {
        return this.queryOrchestrator.submit(this.searchContext.getIndexNames(), this.searchContext.getIndexManagerContexts(), this.routingKeys, work);
    }

    private Explanation doExplain(String indexName, String id) {
        this.timeoutManager.start();
        Query filter = this.searchContext.getFilterOrNull(this.sessionContext.tenantIdentifier());
        ReadWork<Explanation> work = this.workFactory.explain(this.searcher, indexName, id, filter);
        Explanation explanation = this.doSubmit(work);
        this.timeoutManager.stop();
        return explanation;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutManager = this.searchContext.createTimeoutManager(this.luceneQuery, timeout, timeUnit, true);
        this.searcher.setTimeoutManager(this.timeoutManager);
    }
}

