/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryExtractContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;

class LuceneSearchQueryRequestContext {
    private final BackendSessionContext sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Query luceneQuery;
    private final Sort luceneSort;

    LuceneSearchQueryRequestContext(BackendSessionContext sessionContext, LoadingContext<?, ?> loadingContext, Query luceneQuery, Sort luceneSort) {
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.luceneQuery = luceneQuery;
        this.luceneSort = luceneSort;
    }

    Query getLuceneQuery() {
        return this.luceneQuery;
    }

    Sort getLuceneSort() {
        return this.luceneSort;
    }

    LuceneSearchQueryExtractContext createExtractContext(IndexSearcher indexSearcher, LuceneCollectors luceneCollectors) {
        return new LuceneSearchQueryExtractContext(this.sessionContext, this.loadingContext.createProjectionHitMapper(), indexSearcher, this.luceneQuery, luceneCollectors);
    }
}

