/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneFieldAggregationBuilderFactory<F>
implements LuceneFieldAggregationBuilderFactory {
    protected static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final boolean aggregable;
    protected final DslConverter<?, ? extends F> toFieldValueConverter;
    protected final ProjectionConverter<? super F, ?> fromFieldValueConverter;

    public AbstractLuceneFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends F> toFieldValueConverter, ProjectionConverter<? super F, ?> fromFieldValueConverter) {
        this.aggregable = aggregable;
        this.toFieldValueConverter = toFieldValueConverter;
        this.fromFieldValueConverter = fromFieldValueConverter;
    }

    @Override
    public boolean isAggregable() {
        return this.aggregable;
    }

    @Override
    public boolean hasCompatibleCodec(LuceneFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractLuceneFieldAggregationBuilderFactory castedOther = (AbstractLuceneFieldAggregationBuilderFactory)other;
        return this.aggregable == castedOther.aggregable && this.getCodec().isCompatibleWith(castedOther.getCodec());
    }

    @Override
    public boolean hasCompatibleConverter(LuceneFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractLuceneFieldAggregationBuilderFactory castedOther = (AbstractLuceneFieldAggregationBuilderFactory)other;
        return this.toFieldValueConverter.isCompatibleWith(castedOther.toFieldValueConverter) && this.fromFieldValueConverter.isCompatibleWith(castedOther.fromFieldValueConverter);
    }

    protected abstract LuceneFieldCodec<F> getCodec();

    protected void checkAggregable(String absoluteFieldPath) {
        if (!this.aggregable) {
            throw log.nonAggregableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

