/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneStandardFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneTextTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneTextFieldAggregationBuilderFactory
extends AbstractLuceneStandardFieldAggregationBuilderFactory<String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneFieldCodec<String> codec;
    private final boolean tokenized;

    public LuceneTextFieldAggregationBuilderFactory(boolean aggregable, DslConverter<?, ? extends String> toFieldValueConverter, DslConverter<? super String, ? extends String> rawToFieldValueConverter, ProjectionConverter<? super String, ?> fromFieldValueConverter, ProjectionConverter<? super String, String> rawFromFieldValueConverter, LuceneFieldCodec<String> codec, boolean tokenized) {
        super(aggregable, toFieldValueConverter, rawToFieldValueConverter, fromFieldValueConverter, rawFromFieldValueConverter);
        this.codec = codec;
        this.tokenized = tokenized;
    }

    @Override
    public <K> TermsAggregationBuilder<K> createTermsAggregationBuilder(LuceneSearchContext searchContext, String nestedDocumentPath, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        if (this.tokenized) {
            throw log.termsAggregationsNotSupportedByAnalyzedTextFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        this.checkAggregable(absoluteFieldPath);
        ProjectionConverter fromFieldValueConverter = this.getFromFieldValueConverter(absoluteFieldPath, expectedType, convert);
        return new LuceneTextTermsAggregation.Builder<K>(searchContext, nestedDocumentPath, absoluteFieldPath, fromFieldValueConverter);
    }

    @Override
    public <K> RangeAggregationBuilder<K> createRangeAggregationBuilder(LuceneSearchContext searchContext, String nestedDocumentPath, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        throw log.rangeAggregationsNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    protected LuceneFieldCodec<String> getCodec() {
        return this.codec;
    }
}

